/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvmMemory;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvmVersion;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterJvm
implements JsonpSerializable {
    private final long maxUptimeInMillis;
    @Nullable
    private final Time maxUptime;
    private final ClusterJvmMemory mem;
    private final long threads;
    private final List<ClusterJvmVersion> versions;
    public static final JsonpDeserializer<ClusterJvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvm::setupClusterJvmDeserializer);

    private ClusterJvm(Builder builder) {
        this.maxUptimeInMillis = ApiTypeHelper.requireNonNull(builder.maxUptimeInMillis, (Object)this, "maxUptimeInMillis", 0L);
        this.maxUptime = builder.maxUptime;
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.threads = ApiTypeHelper.requireNonNull(builder.threads, (Object)this, "threads", 0L);
        this.versions = ApiTypeHelper.unmodifiableRequired(builder.versions, (Object)this, "versions");
    }

    public static ClusterJvm of(Function<Builder, ObjectBuilder<ClusterJvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long maxUptimeInMillis() {
        return this.maxUptimeInMillis;
    }

    @Nullable
    public final Time maxUptime() {
        return this.maxUptime;
    }

    public final ClusterJvmMemory mem() {
        return this.mem;
    }

    public final long threads() {
        return this.threads;
    }

    public final List<ClusterJvmVersion> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_uptime_in_millis");
        generator.write(this.maxUptimeInMillis);
        if (this.maxUptime != null) {
            generator.writeKey("max_uptime");
            this.maxUptime.serialize(generator, mapper);
        }
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        generator.write(this.threads);
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (ClusterJvmVersion item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxUptimeInMillis, JsonpDeserializer.longDeserializer(), "max_uptime_in_millis");
        op.add(Builder::maxUptime, Time._DESERIALIZER, "max_uptime");
        op.add(Builder::mem, ClusterJvmMemory._DESERIALIZER, "mem");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(ClusterJvmVersion._DESERIALIZER), "versions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterJvm> {
        private Long maxUptimeInMillis;
        @Nullable
        private Time maxUptime;
        private ClusterJvmMemory mem;
        private Long threads;
        private List<ClusterJvmVersion> versions;

        public Builder() {
        }

        private Builder(ClusterJvm instance) {
            this.maxUptimeInMillis = instance.maxUptimeInMillis;
            this.maxUptime = instance.maxUptime;
            this.mem = instance.mem;
            this.threads = instance.threads;
            this.versions = instance.versions;
        }

        public final Builder maxUptimeInMillis(long value) {
            this.maxUptimeInMillis = value;
            return this;
        }

        public final Builder maxUptime(@Nullable Time value) {
            this.maxUptime = value;
            return this;
        }

        public final Builder maxUptime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxUptime(fn.apply(new Time.Builder()).build());
        }

        public final Builder mem(ClusterJvmMemory value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<ClusterJvmMemory.Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
            return this.mem(fn.apply(new ClusterJvmMemory.Builder()).build());
        }

        public final Builder threads(long value) {
            this.threads = value;
            return this;
        }

        public final Builder versions(List<ClusterJvmVersion> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        public final Builder versions(ClusterJvmVersion value, ClusterJvmVersion ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        public final Builder versions(Function<ClusterJvmVersion.Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
            return this.versions(fn.apply(new ClusterJvmVersion.Builder()).build(), new ClusterJvmVersion[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterJvm build() {
            this._checkSingleUse();
            return new ClusterJvm(this);
        }
    }
}

