/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.AliasesResponse;
import co.elastic.clients.elasticsearch.cat.CatAliasesColumn;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AliasesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<ExpandWildcard> expandWildcards;
    private final List<String> h;
    @Nullable
    private final Boolean local;
    private final List<String> name;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<AliasesRequest, AliasesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AliasesRequest, AliasesResponse>("es/cat.aliases", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/aliases");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, AliasesResponse._DESERIALIZER);

    private AliasesRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.local = builder.local;
        this.name = ApiTypeHelper.unmodifiable(builder.name);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static AliasesRequest of(Function<Builder, ObjectBuilder<AliasesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    public final List<String> h() {
        return this.h;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    public final List<String> name() {
        return this.name;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AliasesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private List<String> h;
        @Nullable
        private Boolean local;
        @Nullable
        private List<String> name;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(AliasesRequest instance) {
            this.bytes = instance.bytes;
            this.expandWildcards = instance.expandWildcards;
            this.h = instance.h;
            this.local = instance.local;
            this.name = instance.name;
            this.s = instance.s;
            this.time = instance.time;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder h(CatAliasesColumn value, CatAliasesColumn ... values) {
            this.h = Builder._listAdd(this.h, value.jsonValue(), (String[])Arrays.stream(values).map(CatAliasesColumn::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AliasesRequest build() {
            this._checkSingleUse();
            return new AliasesRequest(this);
        }
    }
}

