/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class WrapperQuery
extends QueryBase
implements QueryVariant {
    private final String query;
    public static final JsonpDeserializer<WrapperQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WrapperQuery::setupWrapperQueryDeserializer);

    private WrapperQuery(Builder builder) {
        super(builder);
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static WrapperQuery of(Function<Builder, ObjectBuilder<WrapperQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Wrapper;
    }

    public final String query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("query");
        generator.write(this.query);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWrapperQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WrapperQuery> {
        private String query;

        public Builder() {
        }

        private Builder(WrapperQuery instance) {
            this.query = instance.query;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WrapperQuery build() {
            this._checkSingleUse();
            return new WrapperQuery(this);
        }
    }
}

