/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.TokenPruningConfig;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WeightedTokensQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final Map<String, Float> tokens;
    @Nullable
    private final TokenPruningConfig pruningConfig;
    public static final JsonpDeserializer<WeightedTokensQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedTokensQuery::setupWeightedTokensQueryDeserializer);

    private WeightedTokensQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.tokens = ApiTypeHelper.unmodifiableRequired(builder.tokens, (Object)this, "tokens");
        this.pruningConfig = builder.pruningConfig;
    }

    public static WeightedTokensQuery of(Function<Builder, ObjectBuilder<WeightedTokensQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.WeightedTokens;
    }

    public final String field() {
        return this.field;
    }

    public final Map<String, Float> tokens() {
        return this.tokens;
    }

    @Nullable
    public final TokenPruningConfig pruningConfig() {
        return this.pruningConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartObject();
            for (Map.Entry<String, Float> item0 : this.tokens.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write((double)item0.getValue().floatValue());
            }
            generator.writeEnd();
        }
        if (this.pruningConfig != null) {
            generator.writeKey("pruning_config");
            this.pruningConfig.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWeightedTokensQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::tokens, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.floatDeserializer()), "tokens");
        op.add(Builder::pruningConfig, TokenPruningConfig._DESERIALIZER, "pruning_config");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WeightedTokensQuery> {
        private String field;
        private Map<String, Float> tokens;
        @Nullable
        private TokenPruningConfig pruningConfig;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder() {
        }

        private Builder(WeightedTokensQuery instance) {
            this.tokens = instance.tokens;
            this.pruningConfig = instance.pruningConfig;
        }

        public final Builder tokens(Map<String, Float> map) {
            this.tokens = Builder._mapPutAll(this.tokens, map);
            return this;
        }

        public final Builder tokens(String key, Float value) {
            this.tokens = Builder._mapPut(this.tokens, key, value);
            return this;
        }

        public final Builder pruningConfig(@Nullable TokenPruningConfig value) {
            this.pruningConfig = value;
            return this;
        }

        public final Builder pruningConfig(Function<TokenPruningConfig.Builder, ObjectBuilder<TokenPruningConfig>> fn) {
            return this.pruningConfig(fn.apply(new TokenPruningConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WeightedTokensQuery build() {
            this._checkSingleUse();
            return new WeightedTokensQuery(this);
        }
    }
}

