/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunctionLinear;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunctionLogarithm;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunctionSaturation;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunctionSigmoid;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankFeatureQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final RankFeatureFunctionSaturation saturation;
    @Nullable
    private final RankFeatureFunctionLogarithm log;
    @Nullable
    private final RankFeatureFunctionLinear linear;
    @Nullable
    private final RankFeatureFunctionSigmoid sigmoid;
    public static final JsonpDeserializer<RankFeatureQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureQuery::setupRankFeatureQueryDeserializer);

    private RankFeatureQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.saturation = builder.saturation;
        this.log = builder.log;
        this.linear = builder.linear;
        this.sigmoid = builder.sigmoid;
    }

    public static RankFeatureQuery of(Function<Builder, ObjectBuilder<RankFeatureQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.RankFeature;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final RankFeatureFunctionSaturation saturation() {
        return this.saturation;
    }

    @Nullable
    public final RankFeatureFunctionLogarithm log() {
        return this.log;
    }

    @Nullable
    public final RankFeatureFunctionLinear linear() {
        return this.linear;
    }

    @Nullable
    public final RankFeatureFunctionSigmoid sigmoid() {
        return this.sigmoid;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.saturation != null) {
            generator.writeKey("saturation");
            this.saturation.serialize(generator, mapper);
        }
        if (this.log != null) {
            generator.writeKey("log");
            this.log.serialize(generator, mapper);
        }
        if (this.linear != null) {
            generator.writeKey("linear");
            this.linear.serialize(generator, mapper);
        }
        if (this.sigmoid != null) {
            generator.writeKey("sigmoid");
            this.sigmoid.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRankFeatureQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::saturation, RankFeatureFunctionSaturation._DESERIALIZER, "saturation");
        op.add(Builder::log, RankFeatureFunctionLogarithm._DESERIALIZER, "log");
        op.add(Builder::linear, RankFeatureFunctionLinear._DESERIALIZER, "linear");
        op.add(Builder::sigmoid, RankFeatureFunctionSigmoid._DESERIALIZER, "sigmoid");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RankFeatureQuery> {
        private String field;
        @Nullable
        private RankFeatureFunctionSaturation saturation;
        @Nullable
        private RankFeatureFunctionLogarithm log;
        @Nullable
        private RankFeatureFunctionLinear linear;
        @Nullable
        private RankFeatureFunctionSigmoid sigmoid;

        public Builder() {
        }

        private Builder(RankFeatureQuery instance) {
            this.field = instance.field;
            this.saturation = instance.saturation;
            this.log = instance.log;
            this.linear = instance.linear;
            this.sigmoid = instance.sigmoid;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder saturation(@Nullable RankFeatureFunctionSaturation value) {
            this.saturation = value;
            return this;
        }

        public final Builder saturation(Function<RankFeatureFunctionSaturation.Builder, ObjectBuilder<RankFeatureFunctionSaturation>> fn) {
            return this.saturation(fn.apply(new RankFeatureFunctionSaturation.Builder()).build());
        }

        public final Builder log(@Nullable RankFeatureFunctionLogarithm value) {
            this.log = value;
            return this;
        }

        public final Builder log(Function<RankFeatureFunctionLogarithm.Builder, ObjectBuilder<RankFeatureFunctionLogarithm>> fn) {
            return this.log(fn.apply(new RankFeatureFunctionLogarithm.Builder()).build());
        }

        public final Builder linear(@Nullable RankFeatureFunctionLinear value) {
            this.linear = value;
            return this;
        }

        public final Builder linear(Function<RankFeatureFunctionLinear.Builder, ObjectBuilder<RankFeatureFunctionLinear>> fn) {
            return this.linear(fn.apply(new RankFeatureFunctionLinear.Builder()).build());
        }

        public final Builder sigmoid(@Nullable RankFeatureFunctionSigmoid value) {
            this.sigmoid = value;
            return this;
        }

        public final Builder sigmoid(Function<RankFeatureFunctionSigmoid.Builder, ObjectBuilder<RankFeatureFunctionSigmoid>> fn) {
            return this.sigmoid(fn.apply(new RankFeatureFunctionSigmoid.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankFeatureQuery build() {
            this._checkSingleUse();
            return new RankFeatureQuery(this);
        }
    }
}

