/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FunctionBoostMode;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FunctionScoreQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final FunctionBoostMode boostMode;
    private final List<FunctionScore> functions;
    @Nullable
    private final Double maxBoost;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query query;
    @Nullable
    private final FunctionScoreMode scoreMode;
    public static final JsonpDeserializer<FunctionScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FunctionScoreQuery::setupFunctionScoreQueryDeserializer);

    private FunctionScoreQuery(Builder builder) {
        super(builder);
        this.boostMode = builder.boostMode;
        this.functions = ApiTypeHelper.unmodifiable(builder.functions);
        this.maxBoost = builder.maxBoost;
        this.minScore = builder.minScore;
        this.query = builder.query;
        this.scoreMode = builder.scoreMode;
    }

    public static FunctionScoreQuery of(Function<Builder, ObjectBuilder<FunctionScoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.FunctionScore;
    }

    @Nullable
    public final FunctionBoostMode boostMode() {
        return this.boostMode;
    }

    public final List<FunctionScore> functions() {
        return this.functions;
    }

    @Nullable
    public final Double maxBoost() {
        return this.maxBoost;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final FunctionScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boostMode != null) {
            generator.writeKey("boost_mode");
            this.boostMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.functions)) {
            generator.writeKey("functions");
            generator.writeStartArray();
            for (FunctionScore item0 : this.functions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxBoost != null) {
            generator.writeKey("max_boost");
            generator.write(this.maxBoost.doubleValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFunctionScoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::boostMode, FunctionBoostMode._DESERIALIZER, "boost_mode");
        op.add(Builder::functions, JsonpDeserializer.arrayDeserializer(FunctionScore._DESERIALIZER), "functions");
        op.add(Builder::maxBoost, JsonpDeserializer.doubleDeserializer(), "max_boost");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::scoreMode, FunctionScoreMode._DESERIALIZER, "score_mode");
        op.shortcutProperty("functions");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FunctionScoreQuery> {
        @Nullable
        private FunctionBoostMode boostMode;
        @Nullable
        private List<FunctionScore> functions;
        @Nullable
        private Double maxBoost;
        @Nullable
        private Double minScore;
        @Nullable
        private Query query;
        @Nullable
        private FunctionScoreMode scoreMode;

        public Builder() {
        }

        private Builder(FunctionScoreQuery instance) {
            this.boostMode = instance.boostMode;
            this.functions = instance.functions;
            this.maxBoost = instance.maxBoost;
            this.minScore = instance.minScore;
            this.query = instance.query;
            this.scoreMode = instance.scoreMode;
        }

        public final Builder boostMode(@Nullable FunctionBoostMode value) {
            this.boostMode = value;
            return this;
        }

        public final Builder functions(List<FunctionScore> list) {
            this.functions = Builder._listAddAll(this.functions, list);
            return this;
        }

        public final Builder functions(FunctionScore value, FunctionScore ... values) {
            this.functions = Builder._listAdd(this.functions, value, values);
            return this;
        }

        public final Builder functions(FunctionScoreVariant value, FunctionScoreVariant ... values) {
            this.functions = Builder._listAdd(this.functions, value._toFunctionScore(), new FunctionScore[0]);
            for (FunctionScoreVariant v : values) {
                Builder._listAdd(this.functions, v._toFunctionScore(), new FunctionScore[0]);
            }
            return this;
        }

        public final Builder functions(Function<FunctionScore.Builder, ObjectBuilder<FunctionScore>> fn) {
            return this.functions(fn.apply(new FunctionScore.Builder()).build(), new FunctionScore[0]);
        }

        public final Builder maxBoost(@Nullable Double value) {
            this.maxBoost = value;
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder scoreMode(@Nullable FunctionScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FunctionScoreQuery build() {
            this._checkSingleUse();
            return new FunctionScoreQuery(this);
        }
    }
}

