/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankFeaturesProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean positiveScoreImpact;
    public static final JsonpDeserializer<RankFeaturesProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeaturesProperty::setupRankFeaturesPropertyDeserializer);

    private RankFeaturesProperty(Builder builder) {
        super(builder);
        this.positiveScoreImpact = builder.positiveScoreImpact;
    }

    public static RankFeaturesProperty of(Function<Builder, ObjectBuilder<RankFeaturesProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.RankFeatures;
    }

    @Nullable
    public final Boolean positiveScoreImpact() {
        return this.positiveScoreImpact;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "rank_features");
        super.serializeInternal(generator, mapper);
        if (this.positiveScoreImpact != null) {
            generator.writeKey("positive_score_impact");
            generator.write(this.positiveScoreImpact.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRankFeaturesPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::positiveScoreImpact, JsonpDeserializer.booleanDeserializer(), "positive_score_impact");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RankFeaturesProperty> {
        @Nullable
        private Boolean positiveScoreImpact;

        public Builder() {
        }

        private Builder(RankFeaturesProperty instance) {
            this.positiveScoreImpact = instance.positiveScoreImpact;
        }

        public final Builder positiveScoreImpact(@Nullable Boolean value) {
            this.positiveScoreImpact = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankFeaturesProperty build() {
            this._checkSingleUse();
            return new RankFeaturesProperty(this);
        }
    }
}

