/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateNanosProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Script script;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final DateTime nullValue;
    @Nullable
    private final Integer precisionStep;
    public static final JsonpDeserializer<DateNanosProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateNanosProperty::setupDateNanosPropertyDeserializer);

    private DateNanosProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.format = builder.format;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.index = builder.index;
        this.script = builder.script;
        this.onScriptError = builder.onScriptError;
        this.nullValue = builder.nullValue;
        this.precisionStep = builder.precisionStep;
    }

    public static DateNanosProperty of(Function<Builder, ObjectBuilder<DateNanosProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DateNanos;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final DateTime nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Integer precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "date_nanos");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            this.nullValue.serialize(generator, mapper);
        }
        if (this.precisionStep != null) {
            generator.writeKey("precision_step");
            generator.write(this.precisionStep.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDateNanosPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::nullValue, DateTime._DESERIALIZER, "null_value");
        op.add(Builder::precisionStep, JsonpDeserializer.integerDeserializer(), "precision_step");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateNanosProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private String format;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;
        @Nullable
        private Script script;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private DateTime nullValue;
        @Nullable
        private Integer precisionStep;

        public Builder() {
        }

        private Builder(DateNanosProperty instance) {
            this.boost = instance.boost;
            this.format = instance.format;
            this.ignoreMalformed = instance.ignoreMalformed;
            this.index = instance.index;
            this.script = instance.script;
            this.onScriptError = instance.onScriptError;
            this.nullValue = instance.nullValue;
            this.precisionStep = instance.precisionStep;
        }

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder nullValue(@Nullable DateTime value) {
            this.nullValue = value;
            return this;
        }

        public final Builder precisionStep(@Nullable Integer value) {
            this.precisionStep = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateNanosProperty build() {
            this._checkSingleUse();
            return new DateNanosProperty(this);
        }
    }
}

