/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AggregateMetricDoubleProperty
extends PropertyBase
implements PropertyVariant {
    private final String defaultMetric;
    @Nullable
    private final Boolean ignoreMalformed;
    private final List<String> metrics;
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;
    public static final JsonpDeserializer<AggregateMetricDoubleProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregateMetricDoubleProperty::setupAggregateMetricDoublePropertyDeserializer);

    private AggregateMetricDoubleProperty(Builder builder) {
        super(builder);
        this.defaultMetric = ApiTypeHelper.requireNonNull(builder.defaultMetric, this, "defaultMetric");
        this.ignoreMalformed = builder.ignoreMalformed;
        this.metrics = ApiTypeHelper.unmodifiableRequired(builder.metrics, (Object)this, "metrics");
        this.timeSeriesMetric = builder.timeSeriesMetric;
    }

    public static AggregateMetricDoubleProperty of(Function<Builder, ObjectBuilder<AggregateMetricDoubleProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.AggregateMetricDouble;
    }

    public final String defaultMetric() {
        return this.defaultMetric;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public final List<String> metrics() {
        return this.metrics;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "aggregate_metric_double");
        super.serializeInternal(generator, mapper);
        generator.writeKey("default_metric");
        generator.write(this.defaultMetric);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (String item0 : this.metrics) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAggregateMetricDoublePropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::defaultMetric, JsonpDeserializer.stringDeserializer(), "default_metric");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "metrics");
        op.add(Builder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AggregateMetricDoubleProperty> {
        private String defaultMetric;
        @Nullable
        private Boolean ignoreMalformed;
        private List<String> metrics;
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;

        public Builder() {
        }

        private Builder(AggregateMetricDoubleProperty instance) {
            this.defaultMetric = instance.defaultMetric;
            this.ignoreMalformed = instance.ignoreMalformed;
            this.metrics = instance.metrics;
            this.timeSeriesMetric = instance.timeSeriesMetric;
        }

        public final Builder defaultMetric(String value) {
            this.defaultMetric = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder metrics(List<String> list) {
            this.metrics = Builder._listAddAll(this.metrics, list);
            return this;
        }

        public final Builder metrics(String value, String ... values) {
            this.metrics = Builder._listAdd(this.metrics, value, values);
            return this;
        }

        public final Builder timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AggregateMetricDoubleProperty build() {
            this._checkSingleUse();
            return new AggregateMetricDoubleProperty(this);
        }
    }
}

