/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceFeatureImportance;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceTopClassEntry;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceAggregate
extends AggregateBase
implements AggregateVariant {
    private final Map<String, JsonData> data;
    @Nullable
    private final FieldValue value;
    private final List<InferenceFeatureImportance> featureImportance;
    private final List<InferenceTopClassEntry> topClasses;
    @Nullable
    private final String warning;
    public static final JsonpDeserializer<InferenceAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceAggregate::setupInferenceAggregateDeserializer);

    private InferenceAggregate(Builder builder) {
        super(builder);
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.value = builder.value;
        this.featureImportance = ApiTypeHelper.unmodifiable(builder.featureImportance);
        this.topClasses = ApiTypeHelper.unmodifiable(builder.topClasses);
        this.warning = builder.warning;
    }

    public static InferenceAggregate of(Function<Builder, ObjectBuilder<InferenceAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Inference;
    }

    public final Map<String, JsonData> data() {
        return this.data;
    }

    @Nullable
    public final FieldValue value() {
        return this.value;
    }

    public final List<InferenceFeatureImportance> featureImportance() {
        return this.featureImportance;
    }

    public final List<InferenceTopClassEntry> topClasses() {
        return this.topClasses;
    }

    @Nullable
    public final String warning() {
        return this.warning;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> entry : this.data.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        super.serializeInternal(generator, mapper);
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.featureImportance)) {
            generator.writeKey("feature_importance");
            generator.writeStartArray();
            for (InferenceFeatureImportance inferenceFeatureImportance : this.featureImportance) {
                inferenceFeatureImportance.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.topClasses)) {
            generator.writeKey("top_classes");
            generator.writeStartArray();
            for (InferenceTopClassEntry inferenceTopClassEntry : this.topClasses) {
                inferenceTopClassEntry.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.warning != null) {
            generator.writeKey("warning");
            generator.write(this.warning);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupInferenceAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
        op.add(Builder::featureImportance, JsonpDeserializer.arrayDeserializer(InferenceFeatureImportance._DESERIALIZER), "feature_importance");
        op.add(Builder::topClasses, JsonpDeserializer.arrayDeserializer(InferenceTopClassEntry._DESERIALIZER), "top_classes");
        op.add(Builder::warning, JsonpDeserializer.stringDeserializer(), "warning");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.data((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceAggregate> {
        @Nullable
        private Map<String, JsonData> data = new HashMap<String, JsonData>();
        @Nullable
        private FieldValue value;
        @Nullable
        private List<InferenceFeatureImportance> featureImportance;
        @Nullable
        private List<InferenceTopClassEntry> topClasses;
        @Nullable
        private String warning;

        public final Builder data(Map<String, JsonData> map) {
            this.data = Builder._mapPutAll(this.data, map);
            return this;
        }

        public final Builder data(String key, JsonData value) {
            this.data = Builder._mapPut(this.data, key, value);
            return this;
        }

        public Builder() {
        }

        private Builder(InferenceAggregate instance) {
            this.value = instance.value;
            this.featureImportance = instance.featureImportance;
            this.topClasses = instance.topClasses;
            this.warning = instance.warning;
            this.data = instance.data;
        }

        public final Builder value(@Nullable FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder value(String value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(long value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(double value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(boolean value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder featureImportance(List<InferenceFeatureImportance> list) {
            this.featureImportance = Builder._listAddAll(this.featureImportance, list);
            return this;
        }

        public final Builder featureImportance(InferenceFeatureImportance value, InferenceFeatureImportance ... values) {
            this.featureImportance = Builder._listAdd(this.featureImportance, value, values);
            return this;
        }

        public final Builder featureImportance(Function<InferenceFeatureImportance.Builder, ObjectBuilder<InferenceFeatureImportance>> fn) {
            return this.featureImportance(fn.apply(new InferenceFeatureImportance.Builder()).build(), new InferenceFeatureImportance[0]);
        }

        public final Builder topClasses(List<InferenceTopClassEntry> list) {
            this.topClasses = Builder._listAddAll(this.topClasses, list);
            return this;
        }

        public final Builder topClasses(InferenceTopClassEntry value, InferenceTopClassEntry ... values) {
            this.topClasses = Builder._listAdd(this.topClasses, value, values);
            return this;
        }

        public final Builder topClasses(Function<InferenceTopClassEntry.Builder, ObjectBuilder<InferenceTopClassEntry>> fn) {
            return this.topClasses(fn.apply(new InferenceTopClassEntry.Builder()).build(), new InferenceTopClassEntry[0]);
        }

        public final Builder warning(@Nullable String value) {
            this.warning = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceAggregate build() {
            this._checkSingleUse();
            return new InferenceAggregate(this);
        }
    }
}

