/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoBounds;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeGeoTileGridAggregation
extends CompositeAggregationBase {
    @Nullable
    private final Integer precision;
    @Nullable
    private final GeoBounds bounds;
    public static final JsonpDeserializer<CompositeGeoTileGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeGeoTileGridAggregation::setupCompositeGeoTileGridAggregationDeserializer);

    private CompositeGeoTileGridAggregation(Builder builder) {
        super(builder);
        this.precision = builder.precision;
        this.bounds = builder.bounds;
    }

    public static CompositeGeoTileGridAggregation of(Function<Builder, ObjectBuilder<CompositeGeoTileGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer precision() {
        return this.precision;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.intValue());
        }
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCompositeGeoTileGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CompositeAggregationBase.setupCompositeAggregationBaseDeserializer(op);
        op.add(Builder::precision, JsonpDeserializer.integerDeserializer(), "precision");
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
    }

    public static class Builder
    extends CompositeAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeGeoTileGridAggregation> {
        @Nullable
        private Integer precision;
        @Nullable
        private GeoBounds bounds;

        public Builder() {
        }

        private Builder(CompositeGeoTileGridAggregation instance) {
            this.precision = instance.precision;
            this.bounds = instance.bounds;
        }

        public final Builder precision(@Nullable Integer value) {
            this.precision = value;
            return this;
        }

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeGeoTileGridAggregation build() {
            this._checkSingleUse();
            return new CompositeGeoTileGridAggregation(this);
        }
    }
}

