/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptTransform
implements TransformVariant,
JsonpSerializable {
    @Nullable
    private final String lang;
    private final Map<String, JsonData> params;
    @Nullable
    private final String source;
    @Nullable
    private final String id;
    public static final JsonpDeserializer<ScriptTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptTransform::setupScriptTransformDeserializer);

    private ScriptTransform(Builder builder) {
        this.lang = builder.lang;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
        this.id = builder.id;
    }

    public static ScriptTransform of(Function<Builder, ObjectBuilder<ScriptTransform>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Transform.Kind _transformKind() {
        return Transform.Kind.Script;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String source() {
        return this.source;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupScriptTransformDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScriptTransform> {
        @Nullable
        private String lang;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String source;
        @Nullable
        private String id;

        public Builder() {
        }

        private Builder(ScriptTransform instance) {
            this.lang = instance.lang;
            this.params = instance.params;
            this.source = instance.source;
            this.id = instance.id;
        }

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptTransform build() {
            this._checkSingleUse();
            return new ScriptTransform(this);
        }
    }
}

