/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldSizeUsage;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionStats
implements JsonpSerializable {
    private final long sizeInBytes;
    @Nullable
    private final String size;
    private final Map<String, FieldSizeUsage> fields;
    public static final JsonpDeserializer<CompletionStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionStats::setupCompletionStatsDeserializer);

    private CompletionStats(Builder builder) {
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
        this.size = builder.size;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static CompletionStats of(Function<Builder, ObjectBuilder<CompletionStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final Map<String, FieldSizeUsage> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldSizeUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCompletionStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldSizeUsage._DESERIALIZER), "fields");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompletionStats> {
        private Long sizeInBytes;
        @Nullable
        private String size;
        @Nullable
        private Map<String, FieldSizeUsage> fields;

        public Builder() {
        }

        private Builder(CompletionStats instance) {
            this.sizeInBytes = instance.sizeInBytes;
            this.size = instance.size;
            this.fields = instance.fields;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder fields(Map<String, FieldSizeUsage> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, FieldSizeUsage value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<FieldSizeUsage.Builder, ObjectBuilder<FieldSizeUsage>> fn) {
            return this.fields(key, fn.apply(new FieldSizeUsage.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionStats build() {
            this._checkSingleUse();
            return new CompletionStats(this);
        }
    }
}

