/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.lang.String;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: _types.aggregations.ChangePointBucket

/**
 *
 * @see <a href=
 *      "../../doc-files/api-spec.html#_types.aggregations.ChangePointBucket">API
 *      specification</a>
 */
@JsonpDeserializable
public class ChangePointBucket extends MultiBucketBase {
	private final FieldValue key;

	// ---------------------------------------------------------------------------------------------

	private ChangePointBucket(Builder builder) {
		super(builder);

		this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");

	}

	public static ChangePointBucket of(Function<Builder, ObjectBuilder<ChangePointBucket>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - API name: {@code key}
	 */
	public final FieldValue key() {
		return this.key;
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		super.serializeInternal(generator, mapper);
		generator.writeKey("key");
		this.key.serialize(generator, mapper);

	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link ChangePointBucket}.
	 */

	public static class Builder extends MultiBucketBase.AbstractBuilder<Builder>
			implements
				ObjectBuilder<ChangePointBucket> {
		private FieldValue key;

		public Builder() {
		}
		private Builder(ChangePointBucket instance) {
			this.key = instance.key;

		}
		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(FieldValue value) {
			this.key = value;
			return this;
		}

		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
			return this.key(fn.apply(new FieldValue.Builder()).build());
		}

		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(String value) {
			this.key = FieldValue.of(value);
			return this;
		}

		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(long value) {
			this.key = FieldValue.of(value);
			return this;
		}

		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(double value) {
			this.key = FieldValue.of(value);
			return this;
		}

		/**
		 * Required - API name: {@code key}
		 */
		public final Builder key(boolean value) {
			this.key = FieldValue.of(value);
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link ChangePointBucket}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public ChangePointBucket build() {
			_checkSingleUse();

			return new ChangePointBucket(this);
		}
	}

	/**
	 * @return New {@link Builder} initialized with field values of this instance
	 */
	public Builder rebuild() {
		return new Builder(this);
	}
	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link ChangePointBucket}
	 */
	public static final JsonpDeserializer<ChangePointBucket> _DESERIALIZER = ObjectBuilderDeserializer
			.lazy(Builder::new, ChangePointBucket::setupChangePointBucketDeserializer);

	protected static void setupChangePointBucketDeserializer(ObjectDeserializer<ChangePointBucket.Builder> op) {
		MultiBucketBase.setupMultiBucketBaseDeserializer(op);
		op.add(Builder::key, FieldValue._DESERIALIZER, "key");

	}

}
