/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.TextEmbeddingByteResult;
import co.elastic.clients.elasticsearch.inference.TextEmbeddingInferenceResultVariant;
import co.elastic.clients.elasticsearch.inference.TextEmbeddingResult;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TextEmbeddingInferenceResult
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TextEmbeddingInferenceResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingInferenceResult::setupTextEmbeddingInferenceResultDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public TextEmbeddingInferenceResult(TextEmbeddingInferenceResultVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._textEmbeddingInferenceResultKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TextEmbeddingInferenceResult(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TextEmbeddingInferenceResult of(Function<Builder, ObjectBuilder<TextEmbeddingInferenceResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTextEmbeddingBytes() {
        return this._kind == Kind.TextEmbeddingBytes;
    }

    public List<TextEmbeddingByteResult> textEmbeddingBytes() {
        return (List)TaggedUnionUtils.get(this, Kind.TextEmbeddingBytes);
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public List<TextEmbeddingResult> textEmbedding() {
        return (List)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case TextEmbeddingBytes: {
                    generator.writeStartArray();
                    for (TextEmbeddingByteResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case TextEmbedding: {
                    generator.writeStartArray();
                    for (TextEmbeddingResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextEmbeddingInferenceResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::textEmbeddingBytes, JsonpDeserializer.arrayDeserializer(TextEmbeddingByteResult._DESERIALIZER), "text_embedding_bytes");
        op.add(Builder::textEmbedding, JsonpDeserializer.arrayDeserializer(TextEmbeddingResult._DESERIALIZER), "text_embedding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextEmbeddingInferenceResult> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<TextEmbeddingInferenceResult> textEmbeddingBytes(List<TextEmbeddingByteResult> v) {
            this._kind = Kind.TextEmbeddingBytes;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TextEmbeddingInferenceResult> textEmbedding(List<TextEmbeddingResult> v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        @Override
        public TextEmbeddingInferenceResult build() {
            this._checkSingleUse();
            return new TextEmbeddingInferenceResult(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        TextEmbeddingBytes("text_embedding_bytes"),
        TextEmbedding("text_embedding");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

