/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FileDetails
implements JsonpSerializable {
    private final long length;
    private final String name;
    private final long recovered;
    public static final JsonpDeserializer<FileDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileDetails::setupFileDetailsDeserializer);

    private FileDetails(Builder builder) {
        this.length = ApiTypeHelper.requireNonNull(builder.length, (Object)this, "length", 0L);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, (Object)this, "recovered", 0L);
    }

    public static FileDetails of(Function<Builder, ObjectBuilder<FileDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long length() {
        return this.length;
    }

    public final String name() {
        return this.name;
    }

    public final long recovered() {
        return this.recovered;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("length");
        generator.write(this.length);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("recovered");
        generator.write(this.recovered);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFileDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::length, JsonpDeserializer.longDeserializer(), "length");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FileDetails> {
        private Long length;
        private String name;
        private Long recovered;

        public final Builder length(long value) {
            this.length = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FileDetails build() {
            this._checkSingleUse();
            return new FileDetails(this);
        }
    }
}

