/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.KnnSearch;
import co.elastic.clients.elasticsearch._types.Rank;
import co.elastic.clients.elasticsearch._types.RankVariant;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SlicedScroll;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.PointInTimeReference;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.RescoreVariant;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SourceConfig source;
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Long batchedReduceSize;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final String df;
    private final List<FieldAndFormat> docvalueFields;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean explain;
    private final Map<String, JsonData> ext;
    private final List<FieldAndFormat> fields;
    @Nullable
    private final Boolean forceSyntheticSource;
    @Nullable
    private final Integer from;
    @Nullable
    private final Highlight highlight;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    private final List<Map<String, Double>> indicesBoost;
    private final List<KnnSearch> knn;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Long maxConcurrentShardRequests;
    @Nullable
    private final String minCompatibleShardNode;
    @Nullable
    private final Double minScore;
    @Nullable
    private final PointInTimeReference pit;
    @Nullable
    private final Query postFilter;
    @Nullable
    private final Long preFilterShardSize;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final String q;
    @Nullable
    private final Query query;
    @Nullable
    private final Rank rank;
    @Nullable
    private final Boolean requestCache;
    private final List<Rescore> rescore;
    @Nullable
    private final Retriever retriever;
    @Nullable
    private final String routing;
    private final Map<String, RuntimeField> runtimeMappings;
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Time scroll;
    private final List<FieldValue> searchAfter;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    @Nullable
    private final Integer size;
    @Nullable
    private final SlicedScroll slice;
    private final List<SortOptions> sort;
    private final List<String> stats;
    private final List<String> storedFields;
    @Nullable
    private final Suggester suggest;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Boolean version;
    public static final JsonpDeserializer<SearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchRequest::setupSearchRequestDeserializer);
    public static final SimpleEndpoint<SearchRequest, ?> _ENDPOINT = new SimpleEndpoint<SearchRequest, SearchResponse<Object>>("es/search", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (request.df != null) {
            params.put("df", request.df);
        }
        if (request.preFilterShardSize != null) {
            params.put("pre_filter_shard_size", String.valueOf(request.preFilterShardSize));
        }
        if (request.minCompatibleShardNode != null) {
            params.put("min_compatible_shard_node", request.minCompatibleShardNode);
        }
        if (request.forceSyntheticSource != null) {
            params.put("force_synthetic_source", String.valueOf(request.forceSyntheticSource));
        }
        if (request.lenient != null) {
            params.put("lenient", String.valueOf(request.lenient));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.analyzer != null) {
            params.put("analyzer", request.analyzer);
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(request.maxConcurrentShardRequests));
        }
        if (request.allowPartialSearchResults != null) {
            params.put("allow_partial_search_results", String.valueOf(request.allowPartialSearchResults));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(request.analyzeWildcard));
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll._toJsonString());
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.jsonValue());
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.q != null) {
            params.put("q", request.q);
        }
        if (request.defaultOperator != null) {
            params.put("default_operator", request.defaultOperator.jsonValue());
        }
        if (request.requestCache != null) {
            params.put("request_cache", String.valueOf(request.requestCache));
        }
        if (request.batchedReduceSize != null) {
            params.put("batched_reduce_size", String.valueOf(request.batchedReduceSize));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SearchResponse._DESERIALIZER);

    private SearchRequest(Builder builder) {
        this.source = builder.source;
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.allowNoIndices = builder.allowNoIndices;
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.batchedReduceSize = builder.batchedReduceSize;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.collapse = builder.collapse;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.docvalueFields = ApiTypeHelper.unmodifiable(builder.docvalueFields);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.explain = builder.explain;
        this.ext = ApiTypeHelper.unmodifiable(builder.ext);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.forceSyntheticSource = builder.forceSyntheticSource;
        this.from = builder.from;
        this.highlight = builder.highlight;
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.indicesBoost = ApiTypeHelper.unmodifiable(builder.indicesBoost);
        this.knn = ApiTypeHelper.unmodifiable(builder.knn);
        this.lenient = builder.lenient;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.minCompatibleShardNode = builder.minCompatibleShardNode;
        this.minScore = builder.minScore;
        this.pit = builder.pit;
        this.postFilter = builder.postFilter;
        this.preFilterShardSize = builder.preFilterShardSize;
        this.preference = builder.preference;
        this.profile = builder.profile;
        this.q = builder.q;
        this.query = builder.query;
        this.rank = builder.rank;
        this.requestCache = builder.requestCache;
        this.rescore = ApiTypeHelper.unmodifiable(builder.rescore);
        this.retriever = builder.retriever;
        this.routing = builder.routing;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.scroll = builder.scroll;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.searchType = builder.searchType;
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.size = builder.size;
        this.slice = builder.slice;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.suggest = builder.suggest;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.version = builder.version;
    }

    public static SearchRequest of(Function<Builder, ObjectBuilder<SearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Long batchedReduceSize() {
        return this.batchedReduceSize;
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public final FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public final String df() {
        return this.df;
    }

    public final List<FieldAndFormat> docvalueFields() {
        return this.docvalueFields;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    public final Map<String, JsonData> ext() {
        return this.ext;
    }

    public final List<FieldAndFormat> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean forceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Highlight highlight() {
        return this.highlight;
    }

    @Deprecated
    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    public final List<Map<String, Double>> indicesBoost() {
        return this.indicesBoost;
    }

    public final List<KnnSearch> knn() {
        return this.knn;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Long maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public final String minCompatibleShardNode() {
        return this.minCompatibleShardNode;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final PointInTimeReference pit() {
        return this.pit;
    }

    @Nullable
    public final Query postFilter() {
        return this.postFilter;
    }

    @Nullable
    public final Long preFilterShardSize() {
        return this.preFilterShardSize;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean profile() {
        return this.profile;
    }

    @Nullable
    public final String q() {
        return this.q;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Rank rank() {
        return this.rank;
    }

    @Nullable
    public final Boolean requestCache() {
        return this.requestCache;
    }

    public final List<Rescore> rescore() {
        return this.rescore;
    }

    @Nullable
    public final Retriever retriever() {
        return this.retriever;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    public final List<FieldValue> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final SlicedScroll slice() {
        return this.slice;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    public final List<String> stats() {
        return this.stats;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final Suggester suggest() {
        return this.suggest;
    }

    @Nullable
    public final Long terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public final String timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.docvalueFields)) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.docvalueFields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.ext)) {
            generator.writeKey("ext");
            generator.writeStartObject();
            for (Map.Entry entry : this.ext.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.fields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indicesBoost)) {
            generator.writeKey("indices_boost");
            generator.writeStartArray();
            for (Map map : this.indicesBoost) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        generator.write(((Double)item1.getValue()).doubleValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.knn)) {
            generator.writeKey("knn");
            generator.writeStartArray();
            for (KnnSearch knnSearch : this.knn) {
                knnSearch.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.pit != null) {
            generator.writeKey("pit");
            this.pit.serialize(generator, mapper);
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.rank != null) {
            generator.writeKey("rank");
            this.rank.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.rescore)) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore rescore : this.rescore) {
                rescore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.retriever != null) {
            generator.writeKey("retriever");
            this.retriever.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.searchAfter) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.stats)) {
            generator.writeKey("stats");
            generator.writeStartArray();
            for (String string : this.stats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            generator.writeKey("stored_fields");
            if (this.storedFields.size() == 1) {
                String singleItem = this.storedFields.get(0);
                generator.write(singleItem);
            } else {
                generator.writeStartArray();
                for (String string : this.storedFields) {
                    generator.write(string);
                }
                generator.writeEnd();
            }
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            this.suggest.serialize(generator, mapper);
        }
        if (this.terminateAfter != null) {
            generator.writeKey("terminate_after");
            generator.write(this.terminateAfter.longValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
    }

    protected static void setupSearchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse");
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "docvalue_fields");
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::ext, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "ext");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "fields");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight");
        op.add(Builder::indicesBoost, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer())), "indices_boost");
        op.add(Builder::knn, JsonpDeserializer.arrayDeserializer(KnnSearch._DESERIALIZER), "knn");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::pit, PointInTimeReference._DESERIALIZER, "pit");
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter");
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::rank, Rank._DESERIALIZER, "rank");
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer(Rescore._DESERIALIZER), "rescore");
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "search_after");
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stats");
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields");
        op.add(Builder::suggest, Suggester._DESERIALIZER, "suggest");
        op.add(Builder::terminateAfter, JsonpDeserializer.longDeserializer(), "terminate_after");
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout");
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version");
    }

    public static <TDocument> Endpoint<SearchRequest, SearchResponse<TDocument>, ErrorResponse> createSearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(SearchResponse.createSearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchRequest> {
        @Nullable
        private SourceConfig source;
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Long batchedReduceSize;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<FieldAndFormat> docvalueFields;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean explain;
        @Nullable
        private Map<String, JsonData> ext;
        @Nullable
        private List<FieldAndFormat> fields;
        @Nullable
        private Boolean forceSyntheticSource;
        @Nullable
        private Integer from;
        @Nullable
        private Highlight highlight;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private List<Map<String, Double>> indicesBoost;
        @Nullable
        private List<KnnSearch> knn;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Long maxConcurrentShardRequests;
        @Nullable
        private String minCompatibleShardNode;
        @Nullable
        private Double minScore;
        @Nullable
        private PointInTimeReference pit;
        @Nullable
        private Query postFilter;
        @Nullable
        private Long preFilterShardSize;
        @Nullable
        private String preference;
        @Nullable
        private Boolean profile;
        @Nullable
        private String q;
        @Nullable
        private Query query;
        @Nullable
        private Rank rank;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private List<Rescore> rescore;
        @Nullable
        private Retriever retriever;
        @Nullable
        private String routing;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Time scroll;
        @Nullable
        private List<FieldValue> searchAfter;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private Integer size;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private List<String> stats;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Suggester suggest;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Boolean version;

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, AggregationVariant value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value._toAggregation());
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder batchedReduceSize(@Nullable Long value) {
            this.batchedReduceSize = value;
            return this;
        }

        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public final Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public final Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public final Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public final Builder docvalueFields(List<FieldAndFormat> list) {
            this.docvalueFields = Builder._listAddAll(this.docvalueFields, list);
            return this;
        }

        public final Builder docvalueFields(FieldAndFormat value, FieldAndFormat ... values) {
            this.docvalueFields = Builder._listAdd(this.docvalueFields, value, values);
            return this;
        }

        public final Builder docvalueFields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.docvalueFields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder ext(Map<String, JsonData> map) {
            this.ext = Builder._mapPutAll(this.ext, map);
            return this;
        }

        public final Builder ext(String key, JsonData value) {
            this.ext = Builder._mapPut(this.ext, key, value);
            return this;
        }

        public final Builder fields(List<FieldAndFormat> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(FieldAndFormat value, FieldAndFormat ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.fields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder forceSyntheticSource(@Nullable Boolean value) {
            this.forceSyntheticSource = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public final Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        @Deprecated
        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder indicesBoost(List<Map<String, Double>> list) {
            this.indicesBoost = Builder._listAddAll(this.indicesBoost, list);
            return this;
        }

        public final Builder indicesBoost(Map<String, Double> value, Map<String, Double> ... values) {
            this.indicesBoost = Builder._listAdd(this.indicesBoost, value, values);
            return this;
        }

        public final Builder knn(List<KnnSearch> list) {
            this.knn = Builder._listAddAll(this.knn, list);
            return this;
        }

        public final Builder knn(KnnSearch value, KnnSearch ... values) {
            this.knn = Builder._listAdd(this.knn, value, values);
            return this;
        }

        public final Builder knn(Function<KnnSearch.Builder, ObjectBuilder<KnnSearch>> fn) {
            return this.knn(fn.apply(new KnnSearch.Builder()).build(), new KnnSearch[0]);
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder maxConcurrentShardRequests(@Nullable Long value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public final Builder minCompatibleShardNode(@Nullable String value) {
            this.minCompatibleShardNode = value;
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder pit(@Nullable PointInTimeReference value) {
            this.pit = value;
            return this;
        }

        public final Builder pit(Function<PointInTimeReference.Builder, ObjectBuilder<PointInTimeReference>> fn) {
            return this.pit(fn.apply(new PointInTimeReference.Builder()).build());
        }

        public final Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public final Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder postFilter(QueryVariant value) {
            this.postFilter = value._toQuery();
            return this;
        }

        public final Builder preFilterShardSize(@Nullable Long value) {
            this.preFilterShardSize = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public final Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder rank(@Nullable Rank value) {
            this.rank = value;
            return this;
        }

        public final Builder rank(Function<Rank.Builder, ObjectBuilder<Rank>> fn) {
            return this.rank(fn.apply(new Rank.Builder()).build());
        }

        public final Builder rank(RankVariant value) {
            this.rank = value._toRank();
            return this;
        }

        public final Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public final Builder rescore(List<Rescore> list) {
            this.rescore = Builder._listAddAll(this.rescore, list);
            return this;
        }

        public final Builder rescore(Rescore value, Rescore ... values) {
            this.rescore = Builder._listAdd(this.rescore, value, values);
            return this;
        }

        public final Builder rescore(RescoreVariant value, RescoreVariant ... values) {
            this.rescore = Builder._listAdd(this.rescore, value._toRescore(), new Rescore[0]);
            for (RescoreVariant v : values) {
                Builder._listAdd(this.rescore, v._toRescore(), new Rescore[0]);
            }
            return this;
        }

        public final Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build(), new Rescore[0]);
        }

        public final Builder retriever(@Nullable Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder searchAfter(List<FieldValue> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(FieldValue value, FieldValue ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            for (String v : values) {
                Builder._listAdd(this.searchAfter, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder searchAfter(long value, long ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            for (long v : values) {
                Builder._listAdd(this.searchAfter, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder searchAfter(double value, double ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            for (double v : values) {
                Builder._listAdd(this.searchAfter, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder searchAfter(boolean value, boolean ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            for (boolean v : values) {
                Builder._listAdd(this.searchAfter, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder searchAfter(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.searchAfter(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        public final Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder stats(List<String> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        public final Builder stats(String value, String ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        public final Builder suggest(@Nullable Suggester value) {
            this.suggest = value;
            return this;
        }

        public final Builder suggest(Function<Suggester.Builder, ObjectBuilder<Suggester>> fn) {
            return this.suggest(fn.apply(new Suggester.Builder()).build());
        }

        public final Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public final Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public final Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchRequest build() {
            this._checkSingleUse();
            return new SearchRequest(this);
        }
    }
}

