/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationDecision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationStore;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.Decision;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeAllocationExplanation
implements JsonpSerializable {
    private final List<AllocationDecision> deciders;
    private final Map<String, String> nodeAttributes;
    private final Decision nodeDecision;
    private final String nodeId;
    private final String nodeName;
    private final List<NodeRole> roles;
    @Nullable
    private final AllocationStore store;
    private final String transportAddress;
    private final int weightRanking;
    public static final JsonpDeserializer<NodeAllocationExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAllocationExplanation::setupNodeAllocationExplanationDeserializer);

    private NodeAllocationExplanation(Builder builder) {
        this.deciders = ApiTypeHelper.unmodifiableRequired(builder.deciders, (Object)this, "deciders");
        this.nodeAttributes = ApiTypeHelper.unmodifiableRequired(builder.nodeAttributes, (Object)this, "nodeAttributes");
        this.nodeDecision = ApiTypeHelper.requireNonNull(builder.nodeDecision, this, "nodeDecision");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.store = builder.store;
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.weightRanking = ApiTypeHelper.requireNonNull(builder.weightRanking, (Object)this, "weightRanking", 0);
    }

    public static NodeAllocationExplanation of(Function<Builder, ObjectBuilder<NodeAllocationExplanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<AllocationDecision> deciders() {
        return this.deciders;
    }

    public final Map<String, String> nodeAttributes() {
        return this.nodeAttributes;
    }

    public final Decision nodeDecision() {
        return this.nodeDecision;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final AllocationStore store() {
        return this.store;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final int weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.deciders)) {
            generator.writeKey("deciders");
            generator.writeStartArray();
            for (AllocationDecision allocationDecision : this.deciders) {
                allocationDecision.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodeAttributes)) {
            generator.writeKey("node_attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodeAttributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("node_decision");
        this.nodeDecision.serialize(generator, mapper);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.store != null) {
            generator.writeKey("store");
            this.store.serialize(generator, mapper);
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("weight_ranking");
        generator.write(this.weightRanking);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeAllocationExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deciders, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "deciders");
        op.add(Builder::nodeAttributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "node_attributes");
        op.add(Builder::nodeDecision, Decision._DESERIALIZER, "node_decision");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::store, AllocationStore._DESERIALIZER, "store");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeAllocationExplanation> {
        private List<AllocationDecision> deciders;
        private Map<String, String> nodeAttributes;
        private Decision nodeDecision;
        private String nodeId;
        private String nodeName;
        private List<NodeRole> roles;
        @Nullable
        private AllocationStore store;
        private String transportAddress;
        private Integer weightRanking;

        public final Builder deciders(List<AllocationDecision> list) {
            this.deciders = Builder._listAddAll(this.deciders, list);
            return this;
        }

        public final Builder deciders(AllocationDecision value, AllocationDecision ... values) {
            this.deciders = Builder._listAdd(this.deciders, value, values);
            return this;
        }

        public final Builder deciders(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.deciders(fn.apply(new AllocationDecision.Builder()).build(), new AllocationDecision[0]);
        }

        public final Builder nodeAttributes(Map<String, String> map) {
            this.nodeAttributes = Builder._mapPutAll(this.nodeAttributes, map);
            return this;
        }

        public final Builder nodeAttributes(String key, String value) {
            this.nodeAttributes = Builder._mapPut(this.nodeAttributes, key, value);
            return this;
        }

        public final Builder nodeDecision(Decision value) {
            this.nodeDecision = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder store(@Nullable AllocationStore value) {
            this.store = value;
            return this;
        }

        public final Builder store(Function<AllocationStore.Builder, ObjectBuilder<AllocationStore>> fn) {
            return this.store(fn.apply(new AllocationStore.Builder()).build());
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder weightRanking(int value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeAllocationExplanation build() {
            this._checkSingleUse();
            return new NodeAllocationExplanation(this);
        }
    }
}

