/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.ingest.PipelineConfig;
import co.elastic.clients.elasticsearch.text_structure.EcsCompatibilityType;
import co.elastic.clients.elasticsearch.text_structure.FieldStat;
import co.elastic.clients.elasticsearch.text_structure.FormatType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FindFieldStructureResponse
implements JsonpSerializable {
    private final String charset;
    @Nullable
    private final EcsCompatibilityType ecsCompatibility;
    private final Map<String, FieldStat> fieldStats;
    private final FormatType format;
    @Nullable
    private final String grokPattern;
    private final List<String> javaTimestampFormats;
    private final List<String> jodaTimestampFormats;
    private final PipelineConfig ingestPipeline;
    private final TypeMapping mappings;
    @Nullable
    private final String multilineStartPattern;
    private final boolean needClientTimezone;
    private final int numLinesAnalyzed;
    private final int numMessagesAnalyzed;
    private final String sampleStart;
    @Nullable
    private final String timestampField;
    public static final JsonpDeserializer<FindFieldStructureResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FindFieldStructureResponse::setupFindFieldStructureResponseDeserializer);

    private FindFieldStructureResponse(Builder builder) {
        this.charset = ApiTypeHelper.requireNonNull(builder.charset, this, "charset");
        this.ecsCompatibility = builder.ecsCompatibility;
        this.fieldStats = ApiTypeHelper.unmodifiableRequired(builder.fieldStats, (Object)this, "fieldStats");
        this.format = ApiTypeHelper.requireNonNull(builder.format, this, "format");
        this.grokPattern = builder.grokPattern;
        this.javaTimestampFormats = ApiTypeHelper.unmodifiable(builder.javaTimestampFormats);
        this.jodaTimestampFormats = ApiTypeHelper.unmodifiable(builder.jodaTimestampFormats);
        this.ingestPipeline = ApiTypeHelper.requireNonNull(builder.ingestPipeline, this, "ingestPipeline");
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
        this.multilineStartPattern = builder.multilineStartPattern;
        this.needClientTimezone = ApiTypeHelper.requireNonNull(builder.needClientTimezone, this, "needClientTimezone");
        this.numLinesAnalyzed = ApiTypeHelper.requireNonNull(builder.numLinesAnalyzed, this, "numLinesAnalyzed");
        this.numMessagesAnalyzed = ApiTypeHelper.requireNonNull(builder.numMessagesAnalyzed, this, "numMessagesAnalyzed");
        this.sampleStart = ApiTypeHelper.requireNonNull(builder.sampleStart, this, "sampleStart");
        this.timestampField = builder.timestampField;
    }

    public static FindFieldStructureResponse of(Function<Builder, ObjectBuilder<FindFieldStructureResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String charset() {
        return this.charset;
    }

    @Nullable
    public final EcsCompatibilityType ecsCompatibility() {
        return this.ecsCompatibility;
    }

    public final Map<String, FieldStat> fieldStats() {
        return this.fieldStats;
    }

    public final FormatType format() {
        return this.format;
    }

    @Nullable
    public final String grokPattern() {
        return this.grokPattern;
    }

    public final List<String> javaTimestampFormats() {
        return this.javaTimestampFormats;
    }

    public final List<String> jodaTimestampFormats() {
        return this.jodaTimestampFormats;
    }

    public final PipelineConfig ingestPipeline() {
        return this.ingestPipeline;
    }

    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public final String multilineStartPattern() {
        return this.multilineStartPattern;
    }

    public final boolean needClientTimezone() {
        return this.needClientTimezone;
    }

    public final int numLinesAnalyzed() {
        return this.numLinesAnalyzed;
    }

    public final int numMessagesAnalyzed() {
        return this.numMessagesAnalyzed;
    }

    public final String sampleStart() {
        return this.sampleStart;
    }

    @Nullable
    public final String timestampField() {
        return this.timestampField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("charset");
        generator.write(this.charset);
        if (this.ecsCompatibility != null) {
            generator.writeKey("ecs_compatibility");
            this.ecsCompatibility.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fieldStats)) {
            generator.writeKey("field_stats");
            generator.writeStartObject();
            for (Map.Entry<String, FieldStat> entry : this.fieldStats.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("format");
        this.format.serialize(generator, mapper);
        if (this.grokPattern != null) {
            generator.writeKey("grok_pattern");
            generator.write(this.grokPattern);
        }
        if (ApiTypeHelper.isDefined(this.javaTimestampFormats)) {
            generator.writeKey("java_timestamp_formats");
            generator.writeStartArray();
            for (String string : this.javaTimestampFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.jodaTimestampFormats)) {
            generator.writeKey("joda_timestamp_formats");
            generator.writeStartArray();
            for (String string : this.jodaTimestampFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("ingest_pipeline");
        this.ingestPipeline.serialize(generator, mapper);
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        if (this.multilineStartPattern != null) {
            generator.writeKey("multiline_start_pattern");
            generator.write(this.multilineStartPattern);
        }
        generator.writeKey("need_client_timezone");
        generator.write(this.needClientTimezone);
        generator.writeKey("num_lines_analyzed");
        generator.write(this.numLinesAnalyzed);
        generator.writeKey("num_messages_analyzed");
        generator.write(this.numMessagesAnalyzed);
        generator.writeKey("sample_start");
        generator.write(this.sampleStart);
        if (this.timestampField != null) {
            generator.writeKey("timestamp_field");
            generator.write(this.timestampField);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFindFieldStructureResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charset, JsonpDeserializer.stringDeserializer(), "charset");
        op.add(Builder::ecsCompatibility, EcsCompatibilityType._DESERIALIZER, "ecs_compatibility");
        op.add(Builder::fieldStats, JsonpDeserializer.stringMapDeserializer(FieldStat._DESERIALIZER), "field_stats");
        op.add(Builder::format, FormatType._DESERIALIZER, "format");
        op.add(Builder::grokPattern, JsonpDeserializer.stringDeserializer(), "grok_pattern");
        op.add(Builder::javaTimestampFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "java_timestamp_formats");
        op.add(Builder::jodaTimestampFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "joda_timestamp_formats");
        op.add(Builder::ingestPipeline, PipelineConfig._DESERIALIZER, "ingest_pipeline");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::multilineStartPattern, JsonpDeserializer.stringDeserializer(), "multiline_start_pattern");
        op.add(Builder::needClientTimezone, JsonpDeserializer.booleanDeserializer(), "need_client_timezone");
        op.add(Builder::numLinesAnalyzed, JsonpDeserializer.integerDeserializer(), "num_lines_analyzed");
        op.add(Builder::numMessagesAnalyzed, JsonpDeserializer.integerDeserializer(), "num_messages_analyzed");
        op.add(Builder::sampleStart, JsonpDeserializer.stringDeserializer(), "sample_start");
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FindFieldStructureResponse> {
        private String charset;
        @Nullable
        private EcsCompatibilityType ecsCompatibility;
        private Map<String, FieldStat> fieldStats;
        private FormatType format;
        @Nullable
        private String grokPattern;
        @Nullable
        private List<String> javaTimestampFormats;
        @Nullable
        private List<String> jodaTimestampFormats;
        private PipelineConfig ingestPipeline;
        private TypeMapping mappings;
        @Nullable
        private String multilineStartPattern;
        private Boolean needClientTimezone;
        private Integer numLinesAnalyzed;
        private Integer numMessagesAnalyzed;
        private String sampleStart;
        @Nullable
        private String timestampField;

        public final Builder charset(String value) {
            this.charset = value;
            return this;
        }

        public final Builder ecsCompatibility(@Nullable EcsCompatibilityType value) {
            this.ecsCompatibility = value;
            return this;
        }

        public final Builder fieldStats(Map<String, FieldStat> map) {
            this.fieldStats = Builder._mapPutAll(this.fieldStats, map);
            return this;
        }

        public final Builder fieldStats(String key, FieldStat value) {
            this.fieldStats = Builder._mapPut(this.fieldStats, key, value);
            return this;
        }

        public final Builder fieldStats(String key, Function<FieldStat.Builder, ObjectBuilder<FieldStat>> fn) {
            return this.fieldStats(key, fn.apply(new FieldStat.Builder()).build());
        }

        public final Builder format(FormatType value) {
            this.format = value;
            return this;
        }

        public final Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public final Builder javaTimestampFormats(List<String> list) {
            this.javaTimestampFormats = Builder._listAddAll(this.javaTimestampFormats, list);
            return this;
        }

        public final Builder javaTimestampFormats(String value, String ... values) {
            this.javaTimestampFormats = Builder._listAdd(this.javaTimestampFormats, value, values);
            return this;
        }

        public final Builder jodaTimestampFormats(List<String> list) {
            this.jodaTimestampFormats = Builder._listAddAll(this.jodaTimestampFormats, list);
            return this;
        }

        public final Builder jodaTimestampFormats(String value, String ... values) {
            this.jodaTimestampFormats = Builder._listAdd(this.jodaTimestampFormats, value, values);
            return this;
        }

        public final Builder ingestPipeline(PipelineConfig value) {
            this.ingestPipeline = value;
            return this;
        }

        public final Builder ingestPipeline(Function<PipelineConfig.Builder, ObjectBuilder<PipelineConfig>> fn) {
            return this.ingestPipeline(fn.apply(new PipelineConfig.Builder()).build());
        }

        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder multilineStartPattern(@Nullable String value) {
            this.multilineStartPattern = value;
            return this;
        }

        public final Builder needClientTimezone(boolean value) {
            this.needClientTimezone = value;
            return this;
        }

        public final Builder numLinesAnalyzed(int value) {
            this.numLinesAnalyzed = value;
            return this;
        }

        public final Builder numMessagesAnalyzed(int value) {
            this.numMessagesAnalyzed = value;
            return this;
        }

        public final Builder sampleStart(String value) {
            this.sampleStart = value;
            return this;
        }

        public final Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FindFieldStructureResponse build() {
            this._checkSingleUse();
            return new FindFieldStructureResponse(this);
        }
    }
}

