/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.DetailsInfo;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.SnapshotNodeInfo;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.SummaryInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RepositoryAnalyzeResponse
implements JsonpSerializable {
    private final int blobCount;
    private final String blobPath;
    private final int concurrency;
    private final SnapshotNodeInfo coordinatingNode;
    private final Time deleteElapsed;
    private final long deleteElapsedNanos;
    private final DetailsInfo details;
    private final int earlyReadNodeCount;
    private final List<String> issuesDetected;
    private final Time listingElapsed;
    private final long listingElapsedNanos;
    private final String maxBlobSize;
    private final long maxBlobSizeBytes;
    private final String maxTotalDataSize;
    private final long maxTotalDataSizeBytes;
    private final double rareActionProbability;
    private final int readNodeCount;
    private final String repository;
    private final long seed;
    private final SummaryInfo summary;
    public static final JsonpDeserializer<RepositoryAnalyzeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryAnalyzeResponse::setupRepositoryAnalyzeResponseDeserializer);

    private RepositoryAnalyzeResponse(Builder builder) {
        this.blobCount = ApiTypeHelper.requireNonNull(builder.blobCount, this, "blobCount");
        this.blobPath = ApiTypeHelper.requireNonNull(builder.blobPath, this, "blobPath");
        this.concurrency = ApiTypeHelper.requireNonNull(builder.concurrency, this, "concurrency");
        this.coordinatingNode = ApiTypeHelper.requireNonNull(builder.coordinatingNode, this, "coordinatingNode");
        this.deleteElapsed = ApiTypeHelper.requireNonNull(builder.deleteElapsed, this, "deleteElapsed");
        this.deleteElapsedNanos = ApiTypeHelper.requireNonNull(builder.deleteElapsedNanos, this, "deleteElapsedNanos");
        this.details = ApiTypeHelper.requireNonNull(builder.details, this, "details");
        this.earlyReadNodeCount = ApiTypeHelper.requireNonNull(builder.earlyReadNodeCount, this, "earlyReadNodeCount");
        this.issuesDetected = ApiTypeHelper.unmodifiableRequired(builder.issuesDetected, (Object)this, "issuesDetected");
        this.listingElapsed = ApiTypeHelper.requireNonNull(builder.listingElapsed, this, "listingElapsed");
        this.listingElapsedNanos = ApiTypeHelper.requireNonNull(builder.listingElapsedNanos, this, "listingElapsedNanos");
        this.maxBlobSize = ApiTypeHelper.requireNonNull(builder.maxBlobSize, this, "maxBlobSize");
        this.maxBlobSizeBytes = ApiTypeHelper.requireNonNull(builder.maxBlobSizeBytes, this, "maxBlobSizeBytes");
        this.maxTotalDataSize = ApiTypeHelper.requireNonNull(builder.maxTotalDataSize, this, "maxTotalDataSize");
        this.maxTotalDataSizeBytes = ApiTypeHelper.requireNonNull(builder.maxTotalDataSizeBytes, this, "maxTotalDataSizeBytes");
        this.rareActionProbability = ApiTypeHelper.requireNonNull(builder.rareActionProbability, this, "rareActionProbability");
        this.readNodeCount = ApiTypeHelper.requireNonNull(builder.readNodeCount, this, "readNodeCount");
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.seed = ApiTypeHelper.requireNonNull(builder.seed, this, "seed");
        this.summary = ApiTypeHelper.requireNonNull(builder.summary, this, "summary");
    }

    public static RepositoryAnalyzeResponse of(Function<Builder, ObjectBuilder<RepositoryAnalyzeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int blobCount() {
        return this.blobCount;
    }

    public final String blobPath() {
        return this.blobPath;
    }

    public final int concurrency() {
        return this.concurrency;
    }

    public final SnapshotNodeInfo coordinatingNode() {
        return this.coordinatingNode;
    }

    public final Time deleteElapsed() {
        return this.deleteElapsed;
    }

    public final long deleteElapsedNanos() {
        return this.deleteElapsedNanos;
    }

    public final DetailsInfo details() {
        return this.details;
    }

    public final int earlyReadNodeCount() {
        return this.earlyReadNodeCount;
    }

    public final List<String> issuesDetected() {
        return this.issuesDetected;
    }

    public final Time listingElapsed() {
        return this.listingElapsed;
    }

    public final long listingElapsedNanos() {
        return this.listingElapsedNanos;
    }

    public final String maxBlobSize() {
        return this.maxBlobSize;
    }

    public final long maxBlobSizeBytes() {
        return this.maxBlobSizeBytes;
    }

    public final String maxTotalDataSize() {
        return this.maxTotalDataSize;
    }

    public final long maxTotalDataSizeBytes() {
        return this.maxTotalDataSizeBytes;
    }

    public final double rareActionProbability() {
        return this.rareActionProbability;
    }

    public final int readNodeCount() {
        return this.readNodeCount;
    }

    public final String repository() {
        return this.repository;
    }

    public final long seed() {
        return this.seed;
    }

    public final SummaryInfo summary() {
        return this.summary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("blob_count");
        generator.write(this.blobCount);
        generator.writeKey("blob_path");
        generator.write(this.blobPath);
        generator.writeKey("concurrency");
        generator.write(this.concurrency);
        generator.writeKey("coordinating_node");
        this.coordinatingNode.serialize(generator, mapper);
        generator.writeKey("delete_elapsed");
        this.deleteElapsed.serialize(generator, mapper);
        generator.writeKey("delete_elapsed_nanos");
        generator.write(this.deleteElapsedNanos);
        generator.writeKey("details");
        this.details.serialize(generator, mapper);
        generator.writeKey("early_read_node_count");
        generator.write(this.earlyReadNodeCount);
        if (ApiTypeHelper.isDefined(this.issuesDetected)) {
            generator.writeKey("issues_detected");
            generator.writeStartArray();
            for (String item0 : this.issuesDetected) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("listing_elapsed");
        this.listingElapsed.serialize(generator, mapper);
        generator.writeKey("listing_elapsed_nanos");
        generator.write(this.listingElapsedNanos);
        generator.writeKey("max_blob_size");
        generator.write(this.maxBlobSize);
        generator.writeKey("max_blob_size_bytes");
        generator.write(this.maxBlobSizeBytes);
        generator.writeKey("max_total_data_size");
        generator.write(this.maxTotalDataSize);
        generator.writeKey("max_total_data_size_bytes");
        generator.write(this.maxTotalDataSizeBytes);
        generator.writeKey("rare_action_probability");
        generator.write(this.rareActionProbability);
        generator.writeKey("read_node_count");
        generator.write(this.readNodeCount);
        generator.writeKey("repository");
        generator.write(this.repository);
        generator.writeKey("seed");
        generator.write(this.seed);
        generator.writeKey("summary");
        this.summary.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRepositoryAnalyzeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::blobCount, JsonpDeserializer.integerDeserializer(), "blob_count");
        op.add(Builder::blobPath, JsonpDeserializer.stringDeserializer(), "blob_path");
        op.add(Builder::concurrency, JsonpDeserializer.integerDeserializer(), "concurrency");
        op.add(Builder::coordinatingNode, SnapshotNodeInfo._DESERIALIZER, "coordinating_node");
        op.add(Builder::deleteElapsed, Time._DESERIALIZER, "delete_elapsed");
        op.add(Builder::deleteElapsedNanos, JsonpDeserializer.longDeserializer(), "delete_elapsed_nanos");
        op.add(Builder::details, DetailsInfo._DESERIALIZER, "details");
        op.add(Builder::earlyReadNodeCount, JsonpDeserializer.integerDeserializer(), "early_read_node_count");
        op.add(Builder::issuesDetected, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "issues_detected");
        op.add(Builder::listingElapsed, Time._DESERIALIZER, "listing_elapsed");
        op.add(Builder::listingElapsedNanos, JsonpDeserializer.longDeserializer(), "listing_elapsed_nanos");
        op.add(Builder::maxBlobSize, JsonpDeserializer.stringDeserializer(), "max_blob_size");
        op.add(Builder::maxBlobSizeBytes, JsonpDeserializer.longDeserializer(), "max_blob_size_bytes");
        op.add(Builder::maxTotalDataSize, JsonpDeserializer.stringDeserializer(), "max_total_data_size");
        op.add(Builder::maxTotalDataSizeBytes, JsonpDeserializer.longDeserializer(), "max_total_data_size_bytes");
        op.add(Builder::rareActionProbability, JsonpDeserializer.doubleDeserializer(), "rare_action_probability");
        op.add(Builder::readNodeCount, JsonpDeserializer.integerDeserializer(), "read_node_count");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::seed, JsonpDeserializer.longDeserializer(), "seed");
        op.add(Builder::summary, SummaryInfo._DESERIALIZER, "summary");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoryAnalyzeResponse> {
        private Integer blobCount;
        private String blobPath;
        private Integer concurrency;
        private SnapshotNodeInfo coordinatingNode;
        private Time deleteElapsed;
        private Long deleteElapsedNanos;
        private DetailsInfo details;
        private Integer earlyReadNodeCount;
        private List<String> issuesDetected;
        private Time listingElapsed;
        private Long listingElapsedNanos;
        private String maxBlobSize;
        private Long maxBlobSizeBytes;
        private String maxTotalDataSize;
        private Long maxTotalDataSizeBytes;
        private Double rareActionProbability;
        private Integer readNodeCount;
        private String repository;
        private Long seed;
        private SummaryInfo summary;

        public final Builder blobCount(int value) {
            this.blobCount = value;
            return this;
        }

        public final Builder blobPath(String value) {
            this.blobPath = value;
            return this;
        }

        public final Builder concurrency(int value) {
            this.concurrency = value;
            return this;
        }

        public final Builder coordinatingNode(SnapshotNodeInfo value) {
            this.coordinatingNode = value;
            return this;
        }

        public final Builder coordinatingNode(Function<SnapshotNodeInfo.Builder, ObjectBuilder<SnapshotNodeInfo>> fn) {
            return this.coordinatingNode(fn.apply(new SnapshotNodeInfo.Builder()).build());
        }

        public final Builder deleteElapsed(Time value) {
            this.deleteElapsed = value;
            return this;
        }

        public final Builder deleteElapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.deleteElapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder deleteElapsedNanos(long value) {
            this.deleteElapsedNanos = value;
            return this;
        }

        public final Builder details(DetailsInfo value) {
            this.details = value;
            return this;
        }

        public final Builder details(Function<DetailsInfo.Builder, ObjectBuilder<DetailsInfo>> fn) {
            return this.details(fn.apply(new DetailsInfo.Builder()).build());
        }

        public final Builder earlyReadNodeCount(int value) {
            this.earlyReadNodeCount = value;
            return this;
        }

        public final Builder issuesDetected(List<String> list) {
            this.issuesDetected = Builder._listAddAll(this.issuesDetected, list);
            return this;
        }

        public final Builder issuesDetected(String value, String ... values) {
            this.issuesDetected = Builder._listAdd(this.issuesDetected, value, values);
            return this;
        }

        public final Builder listingElapsed(Time value) {
            this.listingElapsed = value;
            return this;
        }

        public final Builder listingElapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.listingElapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder listingElapsedNanos(long value) {
            this.listingElapsedNanos = value;
            return this;
        }

        public final Builder maxBlobSize(String value) {
            this.maxBlobSize = value;
            return this;
        }

        public final Builder maxBlobSizeBytes(long value) {
            this.maxBlobSizeBytes = value;
            return this;
        }

        public final Builder maxTotalDataSize(String value) {
            this.maxTotalDataSize = value;
            return this;
        }

        public final Builder maxTotalDataSizeBytes(long value) {
            this.maxTotalDataSizeBytes = value;
            return this;
        }

        public final Builder rareActionProbability(double value) {
            this.rareActionProbability = value;
            return this;
        }

        public final Builder readNodeCount(int value) {
            this.readNodeCount = value;
            return this;
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder seed(long value) {
            this.seed = value;
            return this;
        }

        public final Builder summary(SummaryInfo value) {
            this.summary = value;
            return this;
        }

        public final Builder summary(Function<SummaryInfo.Builder, ObjectBuilder<SummaryInfo>> fn) {
            return this.summary(fn.apply(new SummaryInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryAnalyzeResponse build() {
            this._checkSingleUse();
            return new RepositoryAnalyzeResponse(this);
        }
    }
}

