/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.lang.Long;
import java.util.Objects;
import java.util.function.Function;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: watcher._types.ExecutionThreadPool

/**
 *
 * @see <a href=
 *      "../doc-files/api-spec.html#watcher._types.ExecutionThreadPool">API
 *      specification</a>
 */
@JsonpDeserializable
public class ExecutionThreadPool implements JsonpSerializable {
	private final long maxSize;

	private final long queueSize;

	// ---------------------------------------------------------------------------------------------

	private ExecutionThreadPool(Builder builder) {

		this.maxSize = ApiTypeHelper.requireNonNull(builder.maxSize, this, "maxSize");
		this.queueSize = ApiTypeHelper.requireNonNull(builder.queueSize, this, "queueSize");

	}

	public static ExecutionThreadPool of(Function<Builder, ObjectBuilder<ExecutionThreadPool>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - The largest size of the execution thread pool, which indicates the
	 * largest number of concurrent running watches.
	 * <p>
	 * API name: {@code max_size}
	 */
	public final long maxSize() {
		return this.maxSize;
	}

	/**
	 * Required - The number of watches that were triggered and are currently
	 * queued.
	 * <p>
	 * API name: {@code queue_size}
	 */
	public final long queueSize() {
		return this.queueSize;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		generator.writeKey("max_size");
		generator.write(this.maxSize);

		generator.writeKey("queue_size");
		generator.write(this.queueSize);

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link ExecutionThreadPool}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder>
			implements
				ObjectBuilder<ExecutionThreadPool> {
		private Long maxSize;

		private Long queueSize;

		/**
		 * Required - The largest size of the execution thread pool, which indicates the
		 * largest number of concurrent running watches.
		 * <p>
		 * API name: {@code max_size}
		 */
		public final Builder maxSize(long value) {
			this.maxSize = value;
			return this;
		}

		/**
		 * Required - The number of watches that were triggered and are currently
		 * queued.
		 * <p>
		 * API name: {@code queue_size}
		 */
		public final Builder queueSize(long value) {
			this.queueSize = value;
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link ExecutionThreadPool}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public ExecutionThreadPool build() {
			_checkSingleUse();

			return new ExecutionThreadPool(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link ExecutionThreadPool}
	 */
	public static final JsonpDeserializer<ExecutionThreadPool> _DESERIALIZER = ObjectBuilderDeserializer
			.lazy(Builder::new, ExecutionThreadPool::setupExecutionThreadPoolDeserializer);

	protected static void setupExecutionThreadPoolDeserializer(ObjectDeserializer<ExecutionThreadPool.Builder> op) {

		op.add(Builder::maxSize, JsonpDeserializer.longDeserializer(), "max_size");
		op.add(Builder::queueSize, JsonpDeserializer.longDeserializer(), "queue_size");

	}

}
