/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: ingest._types.Pipeline

/**
 *
 * @see <a href="../doc-files/api-spec.html#ingest._types.Pipeline">API
 *      specification</a>
 */
@JsonpDeserializable
public class Pipeline implements JsonpSerializable {
	@Nullable
	private final String description;

	private final List<Processor> onFailure;

	private final List<Processor> processors;

	@Nullable
	private final Long version;

	@Nullable
	private final Boolean deprecated;

	private final Map<String, JsonData> meta;

	// ---------------------------------------------------------------------------------------------

	private Pipeline(Builder builder) {

		this.description = builder.description;
		this.onFailure = ApiTypeHelper.unmodifiable(builder.onFailure);
		this.processors = ApiTypeHelper.unmodifiable(builder.processors);
		this.version = builder.version;
		this.deprecated = builder.deprecated;
		this.meta = ApiTypeHelper.unmodifiable(builder.meta);

	}

	public static Pipeline of(Function<Builder, ObjectBuilder<Pipeline>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Description of the ingest pipeline.
	 * <p>
	 * API name: {@code description}
	 */
	@Nullable
	public final String description() {
		return this.description;
	}

	/**
	 * Processors to run immediately after a processor failure.
	 * <p>
	 * API name: {@code on_failure}
	 */
	public final List<Processor> onFailure() {
		return this.onFailure;
	}

	/**
	 * Processors used to perform transformations on documents before indexing.
	 * Processors run sequentially in the order specified.
	 * <p>
	 * API name: {@code processors}
	 */
	public final List<Processor> processors() {
		return this.processors;
	}

	/**
	 * Version number used by external systems to track ingest pipelines.
	 * <p>
	 * API name: {@code version}
	 */
	@Nullable
	public final Long version() {
		return this.version;
	}

	/**
	 * Marks this ingest pipeline as deprecated. When a deprecated ingest pipeline
	 * is referenced as the default or final pipeline when creating or updating a
	 * non-deprecated index template, Elasticsearch will emit a deprecation warning.
	 * <p>
	 * API name: {@code deprecated}
	 */
	@Nullable
	public final Boolean deprecated() {
		return this.deprecated;
	}

	/**
	 * Arbitrary metadata about the ingest pipeline. This map is not automatically
	 * generated by Elasticsearch.
	 * <p>
	 * API name: {@code _meta}
	 */
	public final Map<String, JsonData> meta() {
		return this.meta;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		if (this.description != null) {
			generator.writeKey("description");
			generator.write(this.description);

		}
		if (ApiTypeHelper.isDefined(this.onFailure)) {
			generator.writeKey("on_failure");
			generator.writeStartArray();
			for (Processor item0 : this.onFailure) {
				item0.serialize(generator, mapper);

			}
			generator.writeEnd();

		}
		if (ApiTypeHelper.isDefined(this.processors)) {
			generator.writeKey("processors");
			generator.writeStartArray();
			for (Processor item0 : this.processors) {
				item0.serialize(generator, mapper);

			}
			generator.writeEnd();

		}
		if (this.version != null) {
			generator.writeKey("version");
			generator.write(this.version);

		}
		if (this.deprecated != null) {
			generator.writeKey("deprecated");
			generator.write(this.deprecated);

		}
		if (ApiTypeHelper.isDefined(this.meta)) {
			generator.writeKey("_meta");
			generator.writeStartObject();
			for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
				generator.writeKey(item0.getKey());
				item0.getValue().serialize(generator, mapper);

			}
			generator.writeEnd();

		}

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link Pipeline}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder> implements ObjectBuilder<Pipeline> {
		@Nullable
		private String description;

		@Nullable
		private List<Processor> onFailure;

		@Nullable
		private List<Processor> processors;

		@Nullable
		private Long version;

		@Nullable
		private Boolean deprecated;

		@Nullable
		private Map<String, JsonData> meta;

		/**
		 * Description of the ingest pipeline.
		 * <p>
		 * API name: {@code description}
		 */
		public final Builder description(@Nullable String value) {
			this.description = value;
			return this;
		}

		/**
		 * Processors to run immediately after a processor failure.
		 * <p>
		 * API name: {@code on_failure}
		 * <p>
		 * Adds all elements of <code>list</code> to <code>onFailure</code>.
		 */
		public final Builder onFailure(List<Processor> list) {
			this.onFailure = _listAddAll(this.onFailure, list);
			return this;
		}

		/**
		 * Processors to run immediately after a processor failure.
		 * <p>
		 * API name: {@code on_failure}
		 * <p>
		 * Adds one or more values to <code>onFailure</code>.
		 */
		public final Builder onFailure(Processor value, Processor... values) {
			this.onFailure = _listAdd(this.onFailure, value, values);
			return this;
		}

		/**
		 * Processors to run immediately after a processor failure.
		 * <p>
		 * API name: {@code on_failure}
		 * <p>
		 * Adds a value to <code>onFailure</code> using a builder lambda.
		 */
		public final Builder onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
			return onFailure(fn.apply(new Processor.Builder()).build());
		}

		/**
		 * Processors used to perform transformations on documents before indexing.
		 * Processors run sequentially in the order specified.
		 * <p>
		 * API name: {@code processors}
		 * <p>
		 * Adds all elements of <code>list</code> to <code>processors</code>.
		 */
		public final Builder processors(List<Processor> list) {
			this.processors = _listAddAll(this.processors, list);
			return this;
		}

		/**
		 * Processors used to perform transformations on documents before indexing.
		 * Processors run sequentially in the order specified.
		 * <p>
		 * API name: {@code processors}
		 * <p>
		 * Adds one or more values to <code>processors</code>.
		 */
		public final Builder processors(Processor value, Processor... values) {
			this.processors = _listAdd(this.processors, value, values);
			return this;
		}

		/**
		 * Processors used to perform transformations on documents before indexing.
		 * Processors run sequentially in the order specified.
		 * <p>
		 * API name: {@code processors}
		 * <p>
		 * Adds a value to <code>processors</code> using a builder lambda.
		 */
		public final Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
			return processors(fn.apply(new Processor.Builder()).build());
		}

		/**
		 * Version number used by external systems to track ingest pipelines.
		 * <p>
		 * API name: {@code version}
		 */
		public final Builder version(@Nullable Long value) {
			this.version = value;
			return this;
		}

		/**
		 * Marks this ingest pipeline as deprecated. When a deprecated ingest pipeline
		 * is referenced as the default or final pipeline when creating or updating a
		 * non-deprecated index template, Elasticsearch will emit a deprecation warning.
		 * <p>
		 * API name: {@code deprecated}
		 */
		public final Builder deprecated(@Nullable Boolean value) {
			this.deprecated = value;
			return this;
		}

		/**
		 * Arbitrary metadata about the ingest pipeline. This map is not automatically
		 * generated by Elasticsearch.
		 * <p>
		 * API name: {@code _meta}
		 * <p>
		 * Adds all entries of <code>map</code> to <code>meta</code>.
		 */
		public final Builder meta(Map<String, JsonData> map) {
			this.meta = _mapPutAll(this.meta, map);
			return this;
		}

		/**
		 * Arbitrary metadata about the ingest pipeline. This map is not automatically
		 * generated by Elasticsearch.
		 * <p>
		 * API name: {@code _meta}
		 * <p>
		 * Adds an entry to <code>meta</code>.
		 */
		public final Builder meta(String key, JsonData value) {
			this.meta = _mapPut(this.meta, key, value);
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link Pipeline}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public Pipeline build() {
			_checkSingleUse();

			return new Pipeline(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link Pipeline}
	 */
	public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new,
			Pipeline::setupPipelineDeserializer);

	protected static void setupPipelineDeserializer(ObjectDeserializer<Pipeline.Builder> op) {

		op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
		op.add(Builder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
		op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors");
		op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
		op.add(Builder::deprecated, JsonpDeserializer.booleanDeserializer(), "deprecated");
		op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");

	}

}
