/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ResolveIndexDataStreamsItem
implements JsonpSerializable {
    private final String name;
    private final String timestampField;
    private final List<String> backingIndices;
    public static final JsonpDeserializer<ResolveIndexDataStreamsItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexDataStreamsItem::setupResolveIndexDataStreamsItemDeserializer);

    private ResolveIndexDataStreamsItem(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timestampField = ApiTypeHelper.requireNonNull(builder.timestampField, this, "timestampField");
        this.backingIndices = ApiTypeHelper.unmodifiableRequired(builder.backingIndices, (Object)this, "backingIndices");
    }

    public static ResolveIndexDataStreamsItem of(Function<Builder, ObjectBuilder<ResolveIndexDataStreamsItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String timestampField() {
        return this.timestampField;
    }

    public final List<String> backingIndices() {
        return this.backingIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("timestamp_field");
        generator.write(this.timestampField);
        if (ApiTypeHelper.isDefined(this.backingIndices)) {
            generator.writeKey("backing_indices");
            generator.writeStartArray();
            for (String item0 : this.backingIndices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupResolveIndexDataStreamsItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field");
        op.add(Builder::backingIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backing_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResolveIndexDataStreamsItem> {
        private String name;
        private String timestampField;
        private List<String> backingIndices;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timestampField(String value) {
            this.timestampField = value;
            return this;
        }

        public final Builder backingIndices(List<String> list) {
            this.backingIndices = Builder._listAddAll(this.backingIndices, list);
            return this;
        }

        public final Builder backingIndices(String value, String ... values) {
            this.backingIndices = Builder._listAdd(this.backingIndices, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveIndexDataStreamsItem build() {
            this._checkSingleUse();
            return new ResolveIndexDataStreamsItem(this);
        }
    }
}

