/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.watcher.AlwaysCondition;
import co.elastic.clients.elasticsearch.watcher.ArrayCompareCondition;
import co.elastic.clients.elasticsearch.watcher.ConditionOp;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.elasticsearch.watcher.NeverCondition;
import co.elastic.clients.elasticsearch.watcher.ScriptCondition;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.Pair;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Condition
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Condition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Condition::setupConditionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Condition(ConditionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._conditionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Condition(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Condition of(Function<Builder, ObjectBuilder<Condition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAlways() {
        return this._kind == Kind.Always;
    }

    public AlwaysCondition always() {
        return (AlwaysCondition)TaggedUnionUtils.get(this, Kind.Always);
    }

    public boolean isArrayCompare() {
        return this._kind == Kind.ArrayCompare;
    }

    public NamedValue<ArrayCompareCondition> arrayCompare() {
        return (NamedValue)TaggedUnionUtils.get(this, Kind.ArrayCompare);
    }

    public boolean isCompare() {
        return this._kind == Kind.Compare;
    }

    public NamedValue<Pair<ConditionOp, FieldValue>> compare() {
        return (NamedValue)TaggedUnionUtils.get(this, Kind.Compare);
    }

    public boolean isNever() {
        return this._kind == Kind.Never;
    }

    public NeverCondition never() {
        return (NeverCondition)TaggedUnionUtils.get(this, Kind.Never);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptCondition script() {
        return (ScriptCondition)TaggedUnionUtils.get(this, Kind.Script);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case ArrayCompare: {
                    generator.writeStartObject();
                    generator.writeKey(((NamedValue)this._value).name());
                    ((ArrayCompareCondition)((NamedValue)this._value).value()).serialize(generator, mapper);
                    generator.writeEnd();
                    break;
                }
                case Compare: {
                    generator.writeStartObject();
                    generator.writeKey(((NamedValue)this._value).name());
                    generator.writeStartObject();
                    generator.writeKey(((ConditionOp)((Pair)((NamedValue)this._value).value()).key()).jsonValue());
                    ((FieldValue)((Pair)((NamedValue)this._value).value()).value()).serialize(generator, mapper);
                    generator.writeEnd();
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::always, AlwaysCondition._DESERIALIZER, "always");
        op.add(Builder::arrayCompare, NamedValue.deserializer(() -> ArrayCompareCondition._DESERIALIZER), "array_compare");
        op.add(Builder::compare, NamedValue.deserializer(() -> Pair.deserializer(k -> (ConditionOp)ConditionOp._DESERIALIZER.parse((String)k), FieldValue._DESERIALIZER)), "compare");
        op.add(Builder::never, NeverCondition._DESERIALIZER, "never");
        op.add(Builder::script, ScriptCondition._DESERIALIZER, "script");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Condition> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Condition> always(AlwaysCondition v) {
            this._kind = Kind.Always;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Condition> always(Function<AlwaysCondition.Builder, ObjectBuilder<AlwaysCondition>> fn) {
            return this.always(fn.apply(new AlwaysCondition.Builder()).build());
        }

        public ObjectBuilder<Condition> arrayCompare(NamedValue<ArrayCompareCondition> v) {
            this._kind = Kind.ArrayCompare;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Condition> compare(NamedValue<Pair<ConditionOp, FieldValue>> v) {
            this._kind = Kind.Compare;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Condition> never(NeverCondition v) {
            this._kind = Kind.Never;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Condition> never(Function<NeverCondition.Builder, ObjectBuilder<NeverCondition>> fn) {
            return this.never(fn.apply(new NeverCondition.Builder()).build());
        }

        public ObjectBuilder<Condition> script(ScriptCondition v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Condition> script(Function<ScriptCondition.Builder, ObjectBuilder<ScriptCondition>> fn) {
            return this.script(fn.apply(new ScriptCondition.Builder()).build());
        }

        @Override
        public Condition build() {
            this._checkSingleUse();
            return new Condition(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Always("always"),
        ArrayCompare("array_compare"),
        Compare("compare"),
        Never("never"),
        Script("script");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

