/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Flattened
extends Base {
    private final int fieldCount;
    public static final JsonpDeserializer<Flattened> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Flattened::setupFlattenedDeserializer);

    private Flattened(Builder builder) {
        super(builder);
        this.fieldCount = ApiTypeHelper.requireNonNull(builder.fieldCount, this, "fieldCount");
    }

    public static Flattened of(Function<Builder, ObjectBuilder<Flattened>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int fieldCount() {
        return this.fieldCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field_count");
        generator.write(this.fieldCount);
    }

    protected static void setupFlattenedDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::fieldCount, JsonpDeserializer.integerDeserializer(), "field_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Flattened> {
        private Integer fieldCount;

        public final Builder fieldCount(int value) {
            this.fieldCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Flattened build() {
            this._checkSingleUse();
            return new Flattened(this);
        }
    }
}

