/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.ModelConfig;
import co.elastic.clients.elasticsearch.inference.PutModelResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class PutModelRequest
extends RequestBase
implements JsonpSerializable {
    private final String modelId;
    private final TaskType taskType;
    private final ModelConfig modelConfig;
    public static final JsonpDeserializer<PutModelRequest> _DESERIALIZER = PutModelRequest.createPutModelRequestDeserializer();
    public static final Endpoint<PutModelRequest, PutModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutModelRequest, PutModelResponse>("es/inference.put_model", request -> "PUT", request -> {
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutModelResponse._DESERIALIZER);

    private PutModelRequest(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.modelConfig = ApiTypeHelper.requireNonNull(builder.modelConfig, this, "modelConfig");
    }

    public static PutModelRequest of(Function<Builder, ObjectBuilder<PutModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    public final TaskType taskType() {
        return this.taskType;
    }

    public final ModelConfig modelConfig() {
        return this.modelConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.modelConfig.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutModelRequest> createPutModelRequestDeserializer() {
        JsonpDeserializer<ModelConfig> valueDeserializer = ModelConfig._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().modelConfig((ModelConfig)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutModelRequest> {
        private String modelId;
        private TaskType taskType;
        private ModelConfig modelConfig;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder taskType(TaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder modelConfig(ModelConfig value) {
            this.modelConfig = value;
            return this;
        }

        public final Builder modelConfig(Function<ModelConfig.Builder, ObjectBuilder<ModelConfig>> fn) {
            return this.modelConfig(fn.apply(new ModelConfig.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            ModelConfig value = ModelConfig._DESERIALIZER.deserialize(parser, mapper);
            return this.modelConfig(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutModelRequest build() {
            this._checkSingleUse();
            return new PutModelRequest(this);
        }
    }
}

