/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.CalendarInterval;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.RateMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RateAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final CalendarInterval unit;
    @Nullable
    private final RateMode mode;
    public static final JsonpDeserializer<RateAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RateAggregation::setupRateAggregationDeserializer);

    private RateAggregation(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.mode = builder.mode;
    }

    public static RateAggregation of(Function<Builder, ObjectBuilder<RateAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Rate;
    }

    @Nullable
    public final CalendarInterval unit() {
        return this.unit;
    }

    @Nullable
    public final RateMode mode() {
        return this.mode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    protected static void setupRateAggregationDeserializer(ObjectDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::unit, CalendarInterval._DESERIALIZER, "unit");
        op.add(Builder::mode, RateMode._DESERIALIZER, "mode");
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RateAggregation> {
        @Nullable
        private CalendarInterval unit;
        @Nullable
        private RateMode mode;

        public final Builder unit(@Nullable CalendarInterval value) {
            this.unit = value;
            return this;
        }

        public final Builder mode(@Nullable RateMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RateAggregation build() {
            this._checkSingleUse();
            return new RateAggregation(this);
        }
    }
}

