/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.IcuTransformDirection;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IcuTransformTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final IcuTransformDirection dir;
    private final String id;
    public static final JsonpDeserializer<IcuTransformTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuTransformTokenFilter::setupIcuTransformTokenFilterDeserializer);

    private IcuTransformTokenFilter(Builder builder) {
        super(builder);
        this.dir = builder.dir;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
    }

    public static IcuTransformTokenFilter of(Function<Builder, ObjectBuilder<IcuTransformTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuTransform;
    }

    @Nullable
    public final IcuTransformDirection dir() {
        return this.dir;
    }

    public final String id() {
        return this.id;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_transform");
        super.serializeInternal(generator, mapper);
        if (this.dir != null) {
            generator.writeKey("dir");
            this.dir.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
    }

    protected static void setupIcuTransformTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dir, IcuTransformDirection._DESERIALIZER, "dir");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuTransformTokenFilter> {
        @Nullable
        private IcuTransformDirection dir;
        private String id;

        public final Builder dir(@Nullable IcuTransformDirection value) {
            this.dir = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuTransformTokenFilter build() {
            this._checkSingleUse();
            return new IcuTransformTokenFilter(this);
        }
    }
}

