/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EqlFeaturesJoin
implements JsonpSerializable {
    private final Number joinQueriesTwo;
    private final Number joinQueriesThree;
    private final Number joinUntil;
    private final Number joinQueriesFiveOrMore;
    private final Number joinQueriesFour;
    public static final JsonpDeserializer<EqlFeaturesJoin> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesJoin::setupEqlFeaturesJoinDeserializer);

    private EqlFeaturesJoin(Builder builder) {
        this.joinQueriesTwo = ApiTypeHelper.requireNonNull(builder.joinQueriesTwo, this, "joinQueriesTwo");
        this.joinQueriesThree = ApiTypeHelper.requireNonNull(builder.joinQueriesThree, this, "joinQueriesThree");
        this.joinUntil = ApiTypeHelper.requireNonNull(builder.joinUntil, this, "joinUntil");
        this.joinQueriesFiveOrMore = ApiTypeHelper.requireNonNull(builder.joinQueriesFiveOrMore, this, "joinQueriesFiveOrMore");
        this.joinQueriesFour = ApiTypeHelper.requireNonNull(builder.joinQueriesFour, this, "joinQueriesFour");
    }

    public static EqlFeaturesJoin of(Function<Builder, ObjectBuilder<EqlFeaturesJoin>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number joinQueriesTwo() {
        return this.joinQueriesTwo;
    }

    public final Number joinQueriesThree() {
        return this.joinQueriesThree;
    }

    public final Number joinUntil() {
        return this.joinUntil;
    }

    public final Number joinQueriesFiveOrMore() {
        return this.joinQueriesFiveOrMore;
    }

    public final Number joinQueriesFour() {
        return this.joinQueriesFour;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("join_queries_two");
        generator.write(this.joinQueriesTwo.doubleValue());
        generator.writeKey("join_queries_three");
        generator.write(this.joinQueriesThree.doubleValue());
        generator.writeKey("join_until");
        generator.write(this.joinUntil.doubleValue());
        generator.writeKey("join_queries_five_or_more");
        generator.write(this.joinQueriesFiveOrMore.doubleValue());
        generator.writeKey("join_queries_four");
        generator.write(this.joinQueriesFour.doubleValue());
    }

    protected static void setupEqlFeaturesJoinDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::joinQueriesTwo, JsonpDeserializer.numberDeserializer(), "join_queries_two");
        op.add(Builder::joinQueriesThree, JsonpDeserializer.numberDeserializer(), "join_queries_three");
        op.add(Builder::joinUntil, JsonpDeserializer.numberDeserializer(), "join_until");
        op.add(Builder::joinQueriesFiveOrMore, JsonpDeserializer.numberDeserializer(), "join_queries_five_or_more");
        op.add(Builder::joinQueriesFour, JsonpDeserializer.numberDeserializer(), "join_queries_four");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EqlFeaturesJoin> {
        private Number joinQueriesTwo;
        private Number joinQueriesThree;
        private Number joinUntil;
        private Number joinQueriesFiveOrMore;
        private Number joinQueriesFour;

        public final Builder joinQueriesTwo(Number value) {
            this.joinQueriesTwo = value;
            return this;
        }

        public final Builder joinQueriesThree(Number value) {
            this.joinQueriesThree = value;
            return this;
        }

        public final Builder joinUntil(Number value) {
            this.joinUntil = value;
            return this;
        }

        public final Builder joinQueriesFiveOrMore(Number value) {
            this.joinQueriesFiveOrMore = value;
            return this;
        }

        public final Builder joinQueriesFour(Number value) {
            this.joinQueriesFour = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EqlFeaturesJoin build() {
            this._checkSingleUse();
            return new EqlFeaturesJoin(this);
        }
    }
}

