/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SampleDiversity
implements JsonpSerializable {
    private final String field;
    private final int maxDocsPerValue;
    public static final JsonpDeserializer<SampleDiversity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SampleDiversity::setupSampleDiversityDeserializer);

    private SampleDiversity(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxDocsPerValue = ApiTypeHelper.requireNonNull(builder.maxDocsPerValue, this, "maxDocsPerValue");
    }

    public static SampleDiversity of(Function<Builder, ObjectBuilder<SampleDiversity>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final int maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("max_docs_per_value");
        generator.write(this.maxDocsPerValue);
    }

    protected static void setupSampleDiversityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::maxDocsPerValue, JsonpDeserializer.integerDeserializer(), "max_docs_per_value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SampleDiversity> {
        private String field;
        private Integer maxDocsPerValue;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder maxDocsPerValue(int value) {
            this.maxDocsPerValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SampleDiversity build() {
            this._checkSingleUse();
            return new SampleDiversity(this);
        }
    }
}

