/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NGramTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Integer maxGram;
    @Nullable
    private final Integer minGram;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<NGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NGramTokenFilter::setupNGramTokenFilterDeserializer);

    private NGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = builder.maxGram;
        this.minGram = builder.minGram;
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static NGramTokenFilter of(Function<Builder, ObjectBuilder<NGramTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Ngram;
    }

    @Nullable
    public final Integer maxGram() {
        return this.maxGram;
    }

    @Nullable
    public final Integer minGram() {
        return this.minGram;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ngram");
        super.serializeInternal(generator, mapper);
        if (this.maxGram != null) {
            generator.writeKey("max_gram");
            generator.write(this.maxGram.intValue());
        }
        if (this.minGram != null) {
            generator.writeKey("min_gram");
            generator.write(this.minGram.intValue());
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
    }

    protected static void setupNGramTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NGramTokenFilter> {
        @Nullable
        private Integer maxGram;
        @Nullable
        private Integer minGram;
        @Nullable
        private Boolean preserveOriginal;

        public final Builder maxGram(@Nullable Integer value) {
            this.maxGram = value;
            return this;
        }

        public final Builder minGram(@Nullable Integer value) {
            this.minGram = value;
            return this;
        }

        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NGramTokenFilter build() {
            this._checkSingleUse();
            return new NGramTokenFilter(this);
        }
    }
}

