/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatusOptions;
import co.elastic.clients.elasticsearch.watcher.InputType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ExecutionResultInput
implements JsonpSerializable {
    private final Map<String, JsonData> payload;
    private final ActionStatusOptions status;
    private final InputType type;
    public static final JsonpDeserializer<ExecutionResultInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionResultInput::setupExecutionResultInputDeserializer);

    private ExecutionResultInput(Builder builder) {
        this.payload = ApiTypeHelper.unmodifiableRequired(builder.payload, (Object)this, "payload");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ExecutionResultInput of(Function<Builder, ObjectBuilder<ExecutionResultInput>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> payload() {
        return this.payload;
    }

    public final ActionStatusOptions status() {
        return this.status;
    }

    public final InputType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.payload)) {
            generator.writeKey("payload");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.payload.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupExecutionResultInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::payload, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "payload");
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status");
        op.add(Builder::type, InputType._DESERIALIZER, "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExecutionResultInput> {
        private Map<String, JsonData> payload;
        private ActionStatusOptions status;
        private InputType type;

        public final Builder payload(Map<String, JsonData> map) {
            this.payload = Builder._mapPutAll(this.payload, map);
            return this;
        }

        public final Builder payload(String key, JsonData value) {
            this.payload = Builder._mapPut(this.payload, key, value);
            return this;
        }

        public final Builder status(ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        public final Builder type(InputType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExecutionResultInput build() {
            this._checkSingleUse();
            return new ExecutionResultInput(this);
        }
    }
}

