/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class BucketInfluencer
implements JsonpSerializable {
    private final double anomalyScore;
    private final long bucketSpan;
    private final String influencerFieldName;
    private final double initialAnomalyScore;
    private final boolean isInterim;
    private final String jobId;
    private final double probability;
    private final double rawAnomalyScore;
    private final String resultType;
    private final Time timestamp;
    public static final JsonpDeserializer<BucketInfluencer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketInfluencer::setupBucketInfluencerDeserializer);

    private BucketInfluencer(Builder builder) {
        this.anomalyScore = ApiTypeHelper.requireNonNull(builder.anomalyScore, this, "anomalyScore");
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, this, "bucketSpan");
        this.influencerFieldName = ApiTypeHelper.requireNonNull(builder.influencerFieldName, this, "influencerFieldName");
        this.initialAnomalyScore = ApiTypeHelper.requireNonNull(builder.initialAnomalyScore, this, "initialAnomalyScore");
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, this, "isInterim");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, this, "probability");
        this.rawAnomalyScore = ApiTypeHelper.requireNonNull(builder.rawAnomalyScore, this, "rawAnomalyScore");
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static BucketInfluencer of(Function<Builder, ObjectBuilder<BucketInfluencer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double anomalyScore() {
        return this.anomalyScore;
    }

    public final long bucketSpan() {
        return this.bucketSpan;
    }

    public final String influencerFieldName() {
        return this.influencerFieldName;
    }

    public final double initialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final double probability() {
        return this.probability;
    }

    public final double rawAnomalyScore() {
        return this.rawAnomalyScore;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final Time timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_score");
        generator.write(this.anomalyScore);
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("influencer_field_name");
        generator.write(this.influencerFieldName);
        generator.writeKey("initial_anomaly_score");
        generator.write(this.initialAnomalyScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("raw_anomaly_score");
        generator.write(this.rawAnomalyScore);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    protected static void setupBucketInfluencerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score");
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span");
        op.add(Builder::influencerFieldName, JsonpDeserializer.stringDeserializer(), "influencer_field_name");
        op.add(Builder::initialAnomalyScore, JsonpDeserializer.doubleDeserializer(), "initial_anomaly_score");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::rawAnomalyScore, JsonpDeserializer.doubleDeserializer(), "raw_anomaly_score");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, Time._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BucketInfluencer> {
        private Double anomalyScore;
        private Long bucketSpan;
        private String influencerFieldName;
        private Double initialAnomalyScore;
        private Boolean isInterim;
        private String jobId;
        private Double probability;
        private Double rawAnomalyScore;
        private String resultType;
        private Time timestamp;

        public final Builder anomalyScore(double value) {
            this.anomalyScore = value;
            return this;
        }

        public final Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder influencerFieldName(String value) {
            this.influencerFieldName = value;
            return this;
        }

        public final Builder initialAnomalyScore(double value) {
            this.initialAnomalyScore = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder rawAnomalyScore(double value) {
            this.rawAnomalyScore = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(Time value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestamp(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timestamp(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketInfluencer build() {
            this._checkSingleUse();
            return new BucketInfluencer(this);
        }
    }
}

