/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RuntimeFieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    private final int scriptlessCount;
    private final int shadowedCount;
    private final List<String> lang;
    private final int linesMax;
    private final int linesTotal;
    private final int charsMax;
    private final int charsTotal;
    private final int sourceMax;
    private final int sourceTotal;
    private final int docMax;
    private final int docTotal;
    public static final JsonpDeserializer<RuntimeFieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldTypes::setupRuntimeFieldTypesDeserializer);

    private RuntimeFieldTypes(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, this, "indexCount");
        this.scriptlessCount = ApiTypeHelper.requireNonNull(builder.scriptlessCount, this, "scriptlessCount");
        this.shadowedCount = ApiTypeHelper.requireNonNull(builder.shadowedCount, this, "shadowedCount");
        this.lang = ApiTypeHelper.unmodifiableRequired(builder.lang, (Object)this, "lang");
        this.linesMax = ApiTypeHelper.requireNonNull(builder.linesMax, this, "linesMax");
        this.linesTotal = ApiTypeHelper.requireNonNull(builder.linesTotal, this, "linesTotal");
        this.charsMax = ApiTypeHelper.requireNonNull(builder.charsMax, this, "charsMax");
        this.charsTotal = ApiTypeHelper.requireNonNull(builder.charsTotal, this, "charsTotal");
        this.sourceMax = ApiTypeHelper.requireNonNull(builder.sourceMax, this, "sourceMax");
        this.sourceTotal = ApiTypeHelper.requireNonNull(builder.sourceTotal, this, "sourceTotal");
        this.docMax = ApiTypeHelper.requireNonNull(builder.docMax, this, "docMax");
        this.docTotal = ApiTypeHelper.requireNonNull(builder.docTotal, this, "docTotal");
    }

    public static RuntimeFieldTypes of(Function<Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final int count() {
        return this.count;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    public final int scriptlessCount() {
        return this.scriptlessCount;
    }

    public final int shadowedCount() {
        return this.shadowedCount;
    }

    public final List<String> lang() {
        return this.lang;
    }

    public final int linesMax() {
        return this.linesMax;
    }

    public final int linesTotal() {
        return this.linesTotal;
    }

    public final int charsMax() {
        return this.charsMax;
    }

    public final int charsTotal() {
        return this.charsTotal;
    }

    public final int sourceMax() {
        return this.sourceMax;
    }

    public final int sourceTotal() {
        return this.sourceTotal;
    }

    public final int docMax() {
        return this.docMax;
    }

    public final int docTotal() {
        return this.docTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("scriptless_count");
        generator.write(this.scriptlessCount);
        generator.writeKey("shadowed_count");
        generator.write(this.shadowedCount);
        if (ApiTypeHelper.isDefined(this.lang)) {
            generator.writeKey("lang");
            generator.writeStartArray();
            for (String item0 : this.lang) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("lines_max");
        generator.write(this.linesMax);
        generator.writeKey("lines_total");
        generator.write(this.linesTotal);
        generator.writeKey("chars_max");
        generator.write(this.charsMax);
        generator.writeKey("chars_total");
        generator.write(this.charsTotal);
        generator.writeKey("source_max");
        generator.write(this.sourceMax);
        generator.writeKey("source_total");
        generator.write(this.sourceTotal);
        generator.writeKey("doc_max");
        generator.write(this.docMax);
        generator.writeKey("doc_total");
        generator.write(this.docTotal);
    }

    protected static void setupRuntimeFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::scriptlessCount, JsonpDeserializer.integerDeserializer(), "scriptless_count");
        op.add(Builder::shadowedCount, JsonpDeserializer.integerDeserializer(), "shadowed_count");
        op.add(Builder::lang, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "lang");
        op.add(Builder::linesMax, JsonpDeserializer.integerDeserializer(), "lines_max");
        op.add(Builder::linesTotal, JsonpDeserializer.integerDeserializer(), "lines_total");
        op.add(Builder::charsMax, JsonpDeserializer.integerDeserializer(), "chars_max");
        op.add(Builder::charsTotal, JsonpDeserializer.integerDeserializer(), "chars_total");
        op.add(Builder::sourceMax, JsonpDeserializer.integerDeserializer(), "source_max");
        op.add(Builder::sourceTotal, JsonpDeserializer.integerDeserializer(), "source_total");
        op.add(Builder::docMax, JsonpDeserializer.integerDeserializer(), "doc_max");
        op.add(Builder::docTotal, JsonpDeserializer.integerDeserializer(), "doc_total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RuntimeFieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        private Integer scriptlessCount;
        private Integer shadowedCount;
        private List<String> lang;
        private Integer linesMax;
        private Integer linesTotal;
        private Integer charsMax;
        private Integer charsTotal;
        private Integer sourceMax;
        private Integer sourceTotal;
        private Integer docMax;
        private Integer docTotal;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder scriptlessCount(int value) {
            this.scriptlessCount = value;
            return this;
        }

        public final Builder shadowedCount(int value) {
            this.shadowedCount = value;
            return this;
        }

        public final Builder lang(List<String> list) {
            this.lang = Builder._listAddAll(this.lang, list);
            return this;
        }

        public final Builder lang(String value, String ... values) {
            this.lang = Builder._listAdd(this.lang, value, values);
            return this;
        }

        public final Builder linesMax(int value) {
            this.linesMax = value;
            return this;
        }

        public final Builder linesTotal(int value) {
            this.linesTotal = value;
            return this;
        }

        public final Builder charsMax(int value) {
            this.charsMax = value;
            return this;
        }

        public final Builder charsTotal(int value) {
            this.charsTotal = value;
            return this;
        }

        public final Builder sourceMax(int value) {
            this.sourceMax = value;
            return this;
        }

        public final Builder sourceTotal(int value) {
            this.sourceTotal = value;
            return this;
        }

        public final Builder docMax(int value) {
            this.docMax = value;
            return this;
        }

        public final Builder docTotal(int value) {
            this.docTotal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeFieldTypes build() {
            this._checkSingleUse();
            return new RuntimeFieldTypes(this);
        }
    }
}

