/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ScoreFunctionBase
implements JsonpSerializable {
    @Nullable
    private final Query filter;
    @Nullable
    private final Double weight;

    protected ScoreFunctionBase(AbstractBuilder<?> builder) {
        this.filter = ((AbstractBuilder)builder).filter;
        this.weight = ((AbstractBuilder)builder).weight;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Double weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write(this.weight.doubleValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupScoreFunctionBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::filter, Query._DESERIALIZER, "filter");
        op.add(AbstractBuilder::weight, JsonpDeserializer.doubleDeserializer(), "weight");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Query filter;
        @Nullable
        private Double weight;

        protected AbstractBuilder() {
        }

        public final BuilderT filter(@Nullable Query value) {
            this.filter = value;
            return (BuilderT)this.self();
        }

        public final BuilderT filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final BuilderT weight(@Nullable Double value) {
            this.weight = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

