/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BooleanEndpoint;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamlCompleteLogoutRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String content;
    private final List<String> ids;
    @Nullable
    private final String queryString;
    private final String realm;
    public static final JsonpDeserializer<SamlCompleteLogoutRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlCompleteLogoutRequest::setupSamlCompleteLogoutRequestDeserializer);
    public static final Endpoint<SamlCompleteLogoutRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<SamlCompleteLogoutRequest>("es/security.saml_complete_logout", request -> "POST", request -> "/_security/saml/complete_logout", (Function<SamlCompleteLogoutRequest, Map<String, String>>)((Function<SamlCompleteLogoutRequest, Map>)request -> Collections.emptyMap()), (Function<SamlCompleteLogoutRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), true, null);

    private SamlCompleteLogoutRequest(Builder builder) {
        this.content = builder.content;
        this.ids = ApiTypeHelper.unmodifiableRequired(builder.ids, (Object)this, "ids");
        this.queryString = builder.queryString;
        this.realm = ApiTypeHelper.requireNonNull(builder.realm, this, "realm");
    }

    public static SamlCompleteLogoutRequest of(Function<Builder, ObjectBuilder<SamlCompleteLogoutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String content() {
        return this.content;
    }

    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String queryString() {
        return this.queryString;
    }

    public final String realm() {
        return this.realm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.content != null) {
            generator.writeKey("content");
            generator.write(this.content);
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String item0 : this.ids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.queryString != null) {
            generator.writeKey("query_string");
            generator.write(this.queryString);
        }
        generator.writeKey("realm");
        generator.write(this.realm);
    }

    protected static void setupSamlCompleteLogoutRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::content, JsonpDeserializer.stringDeserializer(), "content");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::queryString, JsonpDeserializer.stringDeserializer(), "query_string");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SamlCompleteLogoutRequest> {
        @Nullable
        private String content;
        private List<String> ids;
        @Nullable
        private String queryString;
        private String realm;

        public final Builder content(@Nullable String value) {
            this.content = value;
            return this;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder queryString(@Nullable String value) {
            this.queryString = value;
            return this;
        }

        public final Builder realm(String value) {
            this.realm = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamlCompleteLogoutRequest build() {
            this._checkSingleUse();
            return new SamlCompleteLogoutRequest(this);
        }
    }
}

