/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class NodesInfoResponse
extends NodesResponseBase {
    private final String clusterName;
    private final Map<String, NodeInfo> nodes;
    public static final JsonpDeserializer<NodesInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodesInfoResponse::setupNodesInfoResponseDeserializer);

    private NodesInfoResponse(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static NodesInfoResponse of(Function<Builder, ObjectBuilder<NodesInfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Map<String, NodeInfo> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, NodeInfo> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodesInfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeInfo._DESERIALIZER), "nodes");
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NodesInfoResponse> {
        private String clusterName;
        private Map<String, NodeInfo> nodes;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder nodes(Map<String, NodeInfo> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, NodeInfo value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<NodeInfo.Builder, ObjectBuilder<NodeInfo>> fn) {
            return this.nodes(key, fn.apply(new NodeInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesInfoResponse build() {
            this._checkSingleUse();
            return new NodesInfoResponse(this);
        }
    }
}

