/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.GarbageCollector;
import co.elastic.clients.elasticsearch.nodes.JvmClasses;
import co.elastic.clients.elasticsearch.nodes.JvmMemoryStats;
import co.elastic.clients.elasticsearch.nodes.JvmThreads;
import co.elastic.clients.elasticsearch.nodes.NodeBufferPool;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Jvm
implements JsonpSerializable {
    private final Map<String, NodeBufferPool> bufferPools;
    @Nullable
    private final JvmClasses classes;
    @Nullable
    private final GarbageCollector gc;
    @Nullable
    private final JvmMemoryStats mem;
    @Nullable
    private final JvmThreads threads;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final String uptime;
    @Nullable
    private final Long uptimeInMillis;
    public static final JsonpDeserializer<Jvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Jvm::setupJvmDeserializer);

    private Jvm(Builder builder) {
        this.bufferPools = ApiTypeHelper.unmodifiable(builder.bufferPools);
        this.classes = builder.classes;
        this.gc = builder.gc;
        this.mem = builder.mem;
        this.threads = builder.threads;
        this.timestamp = builder.timestamp;
        this.uptime = builder.uptime;
        this.uptimeInMillis = builder.uptimeInMillis;
    }

    public static Jvm of(Function<Builder, ObjectBuilder<Jvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, NodeBufferPool> bufferPools() {
        return this.bufferPools;
    }

    @Nullable
    public final JvmClasses classes() {
        return this.classes;
    }

    @Nullable
    public final GarbageCollector gc() {
        return this.gc;
    }

    @Nullable
    public final JvmMemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final JvmThreads threads() {
        return this.threads;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String uptime() {
        return this.uptime;
    }

    @Nullable
    public final Long uptimeInMillis() {
        return this.uptimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.bufferPools)) {
            generator.writeKey("buffer_pools");
            generator.writeStartObject();
            for (Map.Entry<String, NodeBufferPool> item0 : this.bufferPools.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.classes != null) {
            generator.writeKey("classes");
            this.classes.serialize(generator, mapper);
        }
        if (this.gc != null) {
            generator.writeKey("gc");
            this.gc.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.threads != null) {
            generator.writeKey("threads");
            this.threads.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
        if (this.uptime != null) {
            generator.writeKey("uptime");
            generator.write(this.uptime);
        }
        if (this.uptimeInMillis != null) {
            generator.writeKey("uptime_in_millis");
            generator.write(this.uptimeInMillis.longValue());
        }
    }

    protected static void setupJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bufferPools, JsonpDeserializer.stringMapDeserializer(NodeBufferPool._DESERIALIZER), "buffer_pools");
        op.add(Builder::classes, JvmClasses._DESERIALIZER, "classes");
        op.add(Builder::gc, GarbageCollector._DESERIALIZER, "gc");
        op.add(Builder::mem, JvmMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::threads, JvmThreads._DESERIALIZER, "threads");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::uptime, JsonpDeserializer.stringDeserializer(), "uptime");
        op.add(Builder::uptimeInMillis, JsonpDeserializer.longDeserializer(), "uptime_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Jvm> {
        @Nullable
        private Map<String, NodeBufferPool> bufferPools;
        @Nullable
        private JvmClasses classes;
        @Nullable
        private GarbageCollector gc;
        @Nullable
        private JvmMemoryStats mem;
        @Nullable
        private JvmThreads threads;
        @Nullable
        private Long timestamp;
        @Nullable
        private String uptime;
        @Nullable
        private Long uptimeInMillis;

        public final Builder bufferPools(Map<String, NodeBufferPool> map) {
            this.bufferPools = Builder._mapPutAll(this.bufferPools, map);
            return this;
        }

        public final Builder bufferPools(String key, NodeBufferPool value) {
            this.bufferPools = Builder._mapPut(this.bufferPools, key, value);
            return this;
        }

        public final Builder bufferPools(String key, Function<NodeBufferPool.Builder, ObjectBuilder<NodeBufferPool>> fn) {
            return this.bufferPools(key, fn.apply(new NodeBufferPool.Builder()).build());
        }

        public final Builder classes(@Nullable JvmClasses value) {
            this.classes = value;
            return this;
        }

        public final Builder classes(Function<JvmClasses.Builder, ObjectBuilder<JvmClasses>> fn) {
            return this.classes(fn.apply(new JvmClasses.Builder()).build());
        }

        public final Builder gc(@Nullable GarbageCollector value) {
            this.gc = value;
            return this;
        }

        public final Builder gc(Function<GarbageCollector.Builder, ObjectBuilder<GarbageCollector>> fn) {
            return this.gc(fn.apply(new GarbageCollector.Builder()).build());
        }

        public final Builder mem(@Nullable JvmMemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<JvmMemoryStats.Builder, ObjectBuilder<JvmMemoryStats>> fn) {
            return this.mem(fn.apply(new JvmMemoryStats.Builder()).build());
        }

        public final Builder threads(@Nullable JvmThreads value) {
            this.threads = value;
            return this;
        }

        public final Builder threads(Function<JvmThreads.Builder, ObjectBuilder<JvmThreads>> fn) {
            return this.threads(fn.apply(new JvmThreads.Builder()).build());
        }

        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder uptime(@Nullable String value) {
            this.uptime = value;
            return this;
        }

        public final Builder uptimeInMillis(@Nullable Long value) {
            this.uptimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Jvm build() {
            this._checkSingleUse();
            return new Jvm(this);
        }
    }
}

