/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.EwmaMovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HoltMovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HoltWintersMovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.LinearMovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingAverageAggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.SimpleMovingAverageAggregation;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MovingAverageAggregation
implements TaggedUnion<Kind, MovingAverageAggregationVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final MovingAverageAggregationVariant _value;
    public static final JsonpDeserializer<MovingAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingAverageAggregation::setupMovingAverageAggregationDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final MovingAverageAggregationVariant _get() {
        return this._value;
    }

    public MovingAverageAggregation(MovingAverageAggregationVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._movingAverageAggregationKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private MovingAverageAggregation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static MovingAverageAggregation of(Function<Builder, ObjectBuilder<MovingAverageAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isEwma() {
        return this._kind == Kind.Ewma;
    }

    public EwmaMovingAverageAggregation ewma() {
        return (EwmaMovingAverageAggregation)TaggedUnionUtils.get(this, Kind.Ewma);
    }

    public boolean isHolt() {
        return this._kind == Kind.Holt;
    }

    public HoltMovingAverageAggregation holt() {
        return (HoltMovingAverageAggregation)TaggedUnionUtils.get(this, Kind.Holt);
    }

    public boolean isHoltWinters() {
        return this._kind == Kind.HoltWinters;
    }

    public HoltWintersMovingAverageAggregation holtWinters() {
        return (HoltWintersMovingAverageAggregation)TaggedUnionUtils.get(this, Kind.HoltWinters);
    }

    public boolean isLinear() {
        return this._kind == Kind.Linear;
    }

    public LinearMovingAverageAggregation linear() {
        return (LinearMovingAverageAggregation)TaggedUnionUtils.get(this, Kind.Linear);
    }

    public boolean isSimple() {
        return this._kind == Kind.Simple;
    }

    public SimpleMovingAverageAggregation simple() {
        return (SimpleMovingAverageAggregation)TaggedUnionUtils.get(this, Kind.Simple);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupMovingAverageAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ewma, EwmaMovingAverageAggregation._DESERIALIZER, "ewma");
        op.add(Builder::holt, HoltMovingAverageAggregation._DESERIALIZER, "holt");
        op.add(Builder::holtWinters, HoltWintersMovingAverageAggregation._DESERIALIZER, "holt_winters");
        op.add(Builder::linear, LinearMovingAverageAggregation._DESERIALIZER, "linear");
        op.add(Builder::simple, SimpleMovingAverageAggregation._DESERIALIZER, "simple");
        op.setTypeProperty("model", null);
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MovingAverageAggregation> {
        private Kind _kind;
        private MovingAverageAggregationVariant _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> ewma(EwmaMovingAverageAggregation v) {
            this._kind = Kind.Ewma;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> ewma(Function<EwmaMovingAverageAggregation.Builder, ObjectBuilder<EwmaMovingAverageAggregation>> fn) {
            return this.ewma(fn.apply(new EwmaMovingAverageAggregation.Builder()).build());
        }

        public ObjectBuilder<MovingAverageAggregation> holt(HoltMovingAverageAggregation v) {
            this._kind = Kind.Holt;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> holt(Function<HoltMovingAverageAggregation.Builder, ObjectBuilder<HoltMovingAverageAggregation>> fn) {
            return this.holt(fn.apply(new HoltMovingAverageAggregation.Builder()).build());
        }

        public ObjectBuilder<MovingAverageAggregation> holtWinters(HoltWintersMovingAverageAggregation v) {
            this._kind = Kind.HoltWinters;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> holtWinters(Function<HoltWintersMovingAverageAggregation.Builder, ObjectBuilder<HoltWintersMovingAverageAggregation>> fn) {
            return this.holtWinters(fn.apply(new HoltWintersMovingAverageAggregation.Builder()).build());
        }

        public ObjectBuilder<MovingAverageAggregation> linear(LinearMovingAverageAggregation v) {
            this._kind = Kind.Linear;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> linear(Function<LinearMovingAverageAggregation.Builder, ObjectBuilder<LinearMovingAverageAggregation>> fn) {
            return this.linear(fn.apply(new LinearMovingAverageAggregation.Builder()).build());
        }

        public ObjectBuilder<MovingAverageAggregation> simple(SimpleMovingAverageAggregation v) {
            this._kind = Kind.Simple;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MovingAverageAggregation> simple(Function<SimpleMovingAverageAggregation.Builder, ObjectBuilder<SimpleMovingAverageAggregation>> fn) {
            return this.simple(fn.apply(new SimpleMovingAverageAggregation.Builder()).build());
        }

        @Override
        public MovingAverageAggregation build() {
            this._checkSingleUse();
            return new MovingAverageAggregation(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Ewma("ewma"),
        Holt("holt"),
        HoltWinters("holt_winters"),
        Linear("linear"),
        Simple("simple");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

