/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ScriptTransform;
import co.elastic.clients.elasticsearch._types.SearchTransform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Transform
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Transform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transform::setupTransformDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Transform(TransformVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._transformKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Transform(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Transform of(Function<Builder, ObjectBuilder<Transform>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isChain() {
        return this._kind == Kind.Chain;
    }

    public List<Transform> chain() {
        return (List)TaggedUnionUtils.get(this, Kind.Chain);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptTransform script() {
        return (ScriptTransform)TaggedUnionUtils.get(this, Kind.Script);
    }

    public boolean isSearch() {
        return this._kind == Kind.Search;
    }

    public SearchTransform search() {
        return (SearchTransform)TaggedUnionUtils.get(this, Kind.Search);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Chain: {
                    generator.writeStartArray();
                    for (Transform item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupTransformDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chain, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "chain");
        op.add(Builder::script, ScriptTransform._DESERIALIZER, "script");
        op.add(Builder::search, SearchTransform._DESERIALIZER, "search");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Transform> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Transform> chain(List<Transform> v) {
            this._kind = Kind.Chain;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Transform> script(ScriptTransform v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Transform> script(Function<ScriptTransform.Builder, ObjectBuilder<ScriptTransform>> fn) {
            return this.script(fn.apply(new ScriptTransform.Builder()).build());
        }

        public ObjectBuilder<Transform> search(SearchTransform v) {
            this._kind = Kind.Search;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Transform> search(Function<SearchTransform.Builder, ObjectBuilder<SearchTransform>> fn) {
            return this.search(fn.apply(new SearchTransform.Builder()).build());
        }

        @Override
        public Transform build() {
            this._checkSingleUse();
            return new Transform(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Chain("chain"),
        Script("script"),
        Search("search");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

