/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.EmailAttachment;
import co.elastic.clients.elasticsearch.watcher.EmailBody;
import co.elastic.clients.elasticsearch.watcher.EmailPriority;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Email
implements JsonpSerializable {
    private final List<String> bcc;
    @Nullable
    private final EmailBody body;
    private final List<String> cc;
    @Nullable
    private final String from;
    @Nullable
    private final EmailPriority priority;
    private final List<String> replyTo;
    @Nullable
    private final DateTime sentDate;
    private final String subject;
    private final List<String> to;
    private final Map<String, EmailAttachment> attachments;
    public static final JsonpDeserializer<Email> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Email::setupEmailDeserializer);

    protected Email(AbstractBuilder<?> builder) {
        this.bcc = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).bcc);
        this.body = ((AbstractBuilder)builder).body;
        this.cc = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).cc);
        this.from = ((AbstractBuilder)builder).from;
        this.priority = ((AbstractBuilder)builder).priority;
        this.replyTo = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).replyTo);
        this.sentDate = ((AbstractBuilder)builder).sentDate;
        this.subject = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).subject, this, "subject");
        this.to = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).to, (Object)this, "to");
        this.attachments = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).attachments);
    }

    public static Email emailOf(Function<Builder, ObjectBuilder<Email>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> bcc() {
        return this.bcc;
    }

    @Nullable
    public final EmailBody body() {
        return this.body;
    }

    public final List<String> cc() {
        return this.cc;
    }

    @Nullable
    public final String from() {
        return this.from;
    }

    @Nullable
    public final EmailPriority priority() {
        return this.priority;
    }

    public final List<String> replyTo() {
        return this.replyTo;
    }

    @Nullable
    public final DateTime sentDate() {
        return this.sentDate;
    }

    public final String subject() {
        return this.subject;
    }

    public final List<String> to() {
        return this.to;
    }

    public final Map<String, EmailAttachment> attachments() {
        return this.attachments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.bcc)) {
            generator.writeKey("bcc");
            generator.writeStartArray();
            for (String string : this.bcc) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.body != null) {
            generator.writeKey("body");
            this.body.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.cc)) {
            generator.writeKey("cc");
            generator.writeStartArray();
            for (String string : this.cc) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            this.priority.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.replyTo)) {
            generator.writeKey("reply_to");
            generator.writeStartArray();
            for (String string : this.replyTo) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.sentDate != null) {
            generator.writeKey("sent_date");
            this.sentDate.serialize(generator, mapper);
        }
        generator.writeKey("subject");
        generator.write(this.subject);
        if (ApiTypeHelper.isDefined(this.to)) {
            generator.writeKey("to");
            generator.writeStartArray();
            for (String string : this.to) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.attachments)) {
            generator.writeKey("attachments");
            generator.writeStartObject();
            for (Map.Entry entry : this.attachments.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((EmailAttachment)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupEmailDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::bcc, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bcc");
        op.add(AbstractBuilder::body, EmailBody._DESERIALIZER, "body");
        op.add(AbstractBuilder::cc, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cc");
        op.add(AbstractBuilder::from, JsonpDeserializer.stringDeserializer(), "from");
        op.add(AbstractBuilder::priority, EmailPriority._DESERIALIZER, "priority");
        op.add(AbstractBuilder::replyTo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "reply_to");
        op.add(AbstractBuilder::sentDate, DateTime._DESERIALIZER, "sent_date");
        op.add(AbstractBuilder::subject, JsonpDeserializer.stringDeserializer(), "subject");
        op.add(AbstractBuilder::to, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "to");
        op.add(AbstractBuilder::attachments, JsonpDeserializer.stringMapDeserializer(EmailAttachment._DESERIALIZER), "attachments");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private List<String> bcc;
        @Nullable
        private EmailBody body;
        @Nullable
        private List<String> cc;
        @Nullable
        private String from;
        @Nullable
        private EmailPriority priority;
        @Nullable
        private List<String> replyTo;
        @Nullable
        private DateTime sentDate;
        private String subject;
        private List<String> to;
        @Nullable
        private Map<String, EmailAttachment> attachments;

        protected AbstractBuilder() {
        }

        public final BuilderT bcc(List<String> list) {
            this.bcc = AbstractBuilder._listAddAll(this.bcc, list);
            return this.self();
        }

        public final BuilderT bcc(String value, String ... values) {
            this.bcc = AbstractBuilder._listAdd(this.bcc, value, values);
            return this.self();
        }

        public final BuilderT body(@Nullable EmailBody value) {
            this.body = value;
            return this.self();
        }

        public final BuilderT body(Function<EmailBody.Builder, ObjectBuilder<EmailBody>> fn) {
            return this.body(fn.apply(new EmailBody.Builder()).build());
        }

        public final BuilderT cc(List<String> list) {
            this.cc = AbstractBuilder._listAddAll(this.cc, list);
            return this.self();
        }

        public final BuilderT cc(String value, String ... values) {
            this.cc = AbstractBuilder._listAdd(this.cc, value, values);
            return this.self();
        }

        public final BuilderT from(@Nullable String value) {
            this.from = value;
            return this.self();
        }

        public final BuilderT priority(@Nullable EmailPriority value) {
            this.priority = value;
            return this.self();
        }

        public final BuilderT replyTo(List<String> list) {
            this.replyTo = AbstractBuilder._listAddAll(this.replyTo, list);
            return this.self();
        }

        public final BuilderT replyTo(String value, String ... values) {
            this.replyTo = AbstractBuilder._listAdd(this.replyTo, value, values);
            return this.self();
        }

        public final BuilderT sentDate(@Nullable DateTime value) {
            this.sentDate = value;
            return this.self();
        }

        public final BuilderT subject(String value) {
            this.subject = value;
            return this.self();
        }

        public final BuilderT to(List<String> list) {
            this.to = AbstractBuilder._listAddAll(this.to, list);
            return this.self();
        }

        public final BuilderT to(String value, String ... values) {
            this.to = AbstractBuilder._listAdd(this.to, value, values);
            return this.self();
        }

        public final BuilderT attachments(Map<String, EmailAttachment> map) {
            this.attachments = AbstractBuilder._mapPutAll(this.attachments, map);
            return this.self();
        }

        public final BuilderT attachments(String key, EmailAttachment value) {
            this.attachments = AbstractBuilder._mapPut(this.attachments, key, value);
            return this.self();
        }

        public final BuilderT attachments(String key, Function<EmailAttachment.Builder, ObjectBuilder<EmailAttachment>> fn) {
            return this.attachments(key, fn.apply(new EmailAttachment.Builder()).build());
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Email> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Email build() {
            this._checkSingleUse();
            return new Email(this);
        }
    }
}

