/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Cpu
implements JsonpSerializable {
    @Nullable
    private final Integer percent;
    @Nullable
    private final String sys;
    @Nullable
    private final Long sysInMillis;
    @Nullable
    private final String total;
    @Nullable
    private final Long totalInMillis;
    @Nullable
    private final String user;
    @Nullable
    private final Long userInMillis;
    private final Map<String, Double> loadAverage;
    public static final JsonpDeserializer<Cpu> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Cpu::setupCpuDeserializer);

    private Cpu(Builder builder) {
        this.percent = builder.percent;
        this.sys = builder.sys;
        this.sysInMillis = builder.sysInMillis;
        this.total = builder.total;
        this.totalInMillis = builder.totalInMillis;
        this.user = builder.user;
        this.userInMillis = builder.userInMillis;
        this.loadAverage = ApiTypeHelper.unmodifiable(builder.loadAverage);
    }

    public static Cpu of(Function<Builder, ObjectBuilder<Cpu>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer percent() {
        return this.percent;
    }

    @Nullable
    public final String sys() {
        return this.sys;
    }

    @Nullable
    public final Long sysInMillis() {
        return this.sysInMillis;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    @Nullable
    public final Long totalInMillis() {
        return this.totalInMillis;
    }

    @Nullable
    public final String user() {
        return this.user;
    }

    @Nullable
    public final Long userInMillis() {
        return this.userInMillis;
    }

    public final Map<String, Double> loadAverage() {
        return this.loadAverage;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.percent != null) {
            generator.writeKey("percent");
            generator.write(this.percent.intValue());
        }
        if (this.sys != null) {
            generator.writeKey("sys");
            generator.write(this.sys);
        }
        if (this.sysInMillis != null) {
            generator.writeKey("sys_in_millis");
            generator.write(this.sysInMillis.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.totalInMillis != null) {
            generator.writeKey("total_in_millis");
            generator.write(this.totalInMillis.longValue());
        }
        if (this.user != null) {
            generator.writeKey("user");
            generator.write(this.user);
        }
        if (this.userInMillis != null) {
            generator.writeKey("user_in_millis");
            generator.write(this.userInMillis.longValue());
        }
        if (ApiTypeHelper.isDefined(this.loadAverage)) {
            generator.writeKey("load_average");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.loadAverage.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupCpuDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.integerDeserializer(), "percent");
        op.add(Builder::sys, JsonpDeserializer.stringDeserializer(), "sys");
        op.add(Builder::sysInMillis, JsonpDeserializer.longDeserializer(), "sys_in_millis");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInMillis, JsonpDeserializer.longDeserializer(), "total_in_millis");
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user");
        op.add(Builder::userInMillis, JsonpDeserializer.longDeserializer(), "user_in_millis");
        op.add(Builder::loadAverage, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "load_average");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Cpu> {
        @Nullable
        private Integer percent;
        @Nullable
        private String sys;
        @Nullable
        private Long sysInMillis;
        @Nullable
        private String total;
        @Nullable
        private Long totalInMillis;
        @Nullable
        private String user;
        @Nullable
        private Long userInMillis;
        @Nullable
        private Map<String, Double> loadAverage;

        public final Builder percent(@Nullable Integer value) {
            this.percent = value;
            return this;
        }

        public final Builder sys(@Nullable String value) {
            this.sys = value;
            return this;
        }

        public final Builder sysInMillis(@Nullable Long value) {
            this.sysInMillis = value;
            return this;
        }

        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInMillis(@Nullable Long value) {
            this.totalInMillis = value;
            return this;
        }

        public final Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        public final Builder userInMillis(@Nullable Long value) {
            this.userInMillis = value;
            return this;
        }

        public final Builder loadAverage(Map<String, Double> map) {
            this.loadAverage = Builder._mapPutAll(this.loadAverage, map);
            return this;
        }

        public final Builder loadAverage(String key, Double value) {
            this.loadAverage = Builder._mapPut(this.loadAverage, key, value);
            return this;
        }

        @Override
        public Cpu build() {
            this._checkSingleUse();
            return new Cpu(this);
        }
    }
}

