/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Influencer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetInfluencersResponse
implements JsonpSerializable {
    private final long count;
    private final List<Influencer> influencers;
    public static final JsonpDeserializer<GetInfluencersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetInfluencersResponse::setupGetInfluencersResponseDeserializer);

    private GetInfluencersResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.influencers = ApiTypeHelper.unmodifiableRequired(builder.influencers, (Object)this, "influencers");
    }

    public static GetInfluencersResponse of(Function<Builder, ObjectBuilder<GetInfluencersResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<Influencer> influencers() {
        return this.influencers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.influencers)) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (Influencer item0 : this.influencers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetInfluencersResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influencer._DESERIALIZER), "influencers");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetInfluencersResponse> {
        private Long count;
        private List<Influencer> influencers;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder influencers(List<Influencer> list) {
            this.influencers = Builder._listAddAll(this.influencers, list);
            return this;
        }

        public final Builder influencers(Influencer value, Influencer ... values) {
            this.influencers = Builder._listAdd(this.influencers, value, values);
            return this;
        }

        public final Builder influencers(Function<Influencer.Builder, ObjectBuilder<Influencer>> fn) {
            return this.influencers(fn.apply(new Influencer.Builder()).build(), new Influencer[0]);
        }

        @Override
        public GetInfluencersResponse build() {
            this._checkSingleUse();
            return new GetInfluencersResponse(this);
        }
    }
}

