/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShrinkConfiguration
implements JsonpSerializable {
    private final int numberOfShards;
    public static final JsonpDeserializer<ShrinkConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShrinkConfiguration::setupShrinkConfigurationDeserializer);

    private ShrinkConfiguration(Builder builder) {
        this.numberOfShards = ApiTypeHelper.requireNonNull(builder.numberOfShards, this, "numberOfShards");
    }

    public static ShrinkConfiguration of(Function<Builder, ObjectBuilder<ShrinkConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("number_of_shards");
        generator.write(this.numberOfShards);
    }

    protected static void setupShrinkConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfShards, JsonpDeserializer.integerDeserializer(), "number_of_shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShrinkConfiguration> {
        private Integer numberOfShards;

        public final Builder numberOfShards(int value) {
            this.numberOfShards = value;
            return this;
        }

        @Override
        public ShrinkConfiguration build() {
            this._checkSingleUse();
            return new ShrinkConfiguration(this);
        }
    }
}

