/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Highlight
implements JsonpSerializable {
    private final Map<String, HighlightField> fields;
    @Nullable
    private final String type;
    @Nullable
    private final String boundaryChars;
    @Nullable
    private final Integer boundaryMaxScan;
    @Nullable
    private final BoundaryScanner boundaryScanner;
    @Nullable
    private final String boundaryScannerLocale;
    @Nullable
    private final HighlighterEncoder encoder;
    @Nullable
    private final HighlighterFragmenter fragmenter;
    @Nullable
    private final Integer fragmentOffset;
    @Nullable
    private final Integer fragmentSize;
    @Nullable
    private final Integer maxFragmentLength;
    @Nullable
    private final Integer noMatchSize;
    @Nullable
    private final Integer numberOfFragments;
    @Nullable
    private final HighlighterOrder order;
    private final List<String> postTags;
    private final List<String> preTags;
    @Nullable
    private final Boolean requireFieldMatch;
    @Nullable
    private final HighlighterTagsSchema tagsSchema;
    @Nullable
    private final Query highlightQuery;
    @Nullable
    private final String maxAnalyzedOffset;
    public static final JsonpDeserializer<Highlight> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Highlight::setupHighlightDeserializer);

    private Highlight(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.type = builder.type;
        this.boundaryChars = builder.boundaryChars;
        this.boundaryMaxScan = builder.boundaryMaxScan;
        this.boundaryScanner = builder.boundaryScanner;
        this.boundaryScannerLocale = builder.boundaryScannerLocale;
        this.encoder = builder.encoder;
        this.fragmenter = builder.fragmenter;
        this.fragmentOffset = builder.fragmentOffset;
        this.fragmentSize = builder.fragmentSize;
        this.maxFragmentLength = builder.maxFragmentLength;
        this.noMatchSize = builder.noMatchSize;
        this.numberOfFragments = builder.numberOfFragments;
        this.order = builder.order;
        this.postTags = ApiTypeHelper.unmodifiable(builder.postTags);
        this.preTags = ApiTypeHelper.unmodifiable(builder.preTags);
        this.requireFieldMatch = builder.requireFieldMatch;
        this.tagsSchema = builder.tagsSchema;
        this.highlightQuery = builder.highlightQuery;
        this.maxAnalyzedOffset = builder.maxAnalyzedOffset;
    }

    public static Highlight of(Function<Builder, ObjectBuilder<Highlight>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, HighlightField> fields() {
        return this.fields;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final String boundaryChars() {
        return this.boundaryChars;
    }

    @Nullable
    public final Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    @Nullable
    public final BoundaryScanner boundaryScanner() {
        return this.boundaryScanner;
    }

    @Nullable
    public final String boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Nullable
    public final HighlighterEncoder encoder() {
        return this.encoder;
    }

    @Nullable
    public final HighlighterFragmenter fragmenter() {
        return this.fragmenter;
    }

    @Nullable
    public final Integer fragmentOffset() {
        return this.fragmentOffset;
    }

    @Nullable
    public final Integer fragmentSize() {
        return this.fragmentSize;
    }

    @Nullable
    public final Integer maxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Nullable
    public final Integer noMatchSize() {
        return this.noMatchSize;
    }

    @Nullable
    public final Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    @Nullable
    public final HighlighterOrder order() {
        return this.order;
    }

    public final List<String> postTags() {
        return this.postTags;
    }

    public final List<String> preTags() {
        return this.preTags;
    }

    @Nullable
    public final Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    @Nullable
    public final HighlighterTagsSchema tagsSchema() {
        return this.tagsSchema;
    }

    @Nullable
    public final Query highlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public final String maxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, HighlightField> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
        if (this.boundaryChars != null) {
            generator.writeKey("boundary_chars");
            generator.write(this.boundaryChars);
        }
        if (this.boundaryMaxScan != null) {
            generator.writeKey("boundary_max_scan");
            generator.write(this.boundaryMaxScan.intValue());
        }
        if (this.boundaryScanner != null) {
            generator.writeKey("boundary_scanner");
            this.boundaryScanner.serialize(generator, mapper);
        }
        if (this.boundaryScannerLocale != null) {
            generator.writeKey("boundary_scanner_locale");
            generator.write(this.boundaryScannerLocale);
        }
        if (this.encoder != null) {
            generator.writeKey("encoder");
            this.encoder.serialize(generator, mapper);
        }
        if (this.fragmenter != null) {
            generator.writeKey("fragmenter");
            this.fragmenter.serialize(generator, mapper);
        }
        if (this.fragmentOffset != null) {
            generator.writeKey("fragment_offset");
            generator.write(this.fragmentOffset.intValue());
        }
        if (this.fragmentSize != null) {
            generator.writeKey("fragment_size");
            generator.write(this.fragmentSize.intValue());
        }
        if (this.maxFragmentLength != null) {
            generator.writeKey("max_fragment_length");
            generator.write(this.maxFragmentLength.intValue());
        }
        if (this.noMatchSize != null) {
            generator.writeKey("no_match_size");
            generator.write(this.noMatchSize.intValue());
        }
        if (this.numberOfFragments != null) {
            generator.writeKey("number_of_fragments");
            generator.write(this.numberOfFragments.intValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.postTags)) {
            generator.writeKey("post_tags");
            generator.writeStartArray();
            for (String string : this.postTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.preTags)) {
            generator.writeKey("pre_tags");
            generator.writeStartArray();
            for (String string : this.preTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.requireFieldMatch != null) {
            generator.writeKey("require_field_match");
            generator.write(this.requireFieldMatch.booleanValue());
        }
        if (this.tagsSchema != null) {
            generator.writeKey("tags_schema");
            this.tagsSchema.serialize(generator, mapper);
        }
        if (this.highlightQuery != null) {
            generator.writeKey("highlight_query");
            this.highlightQuery.serialize(generator, mapper);
        }
        if (this.maxAnalyzedOffset != null) {
            generator.writeKey("max_analyzed_offset");
            generator.write(this.maxAnalyzedOffset);
        }
    }

    protected static void setupHighlightDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(HighlightField._DESERIALIZER), "fields");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::boundaryChars, JsonpDeserializer.stringDeserializer(), "boundary_chars");
        op.add(Builder::boundaryMaxScan, JsonpDeserializer.integerDeserializer(), "boundary_max_scan");
        op.add(Builder::boundaryScanner, BoundaryScanner._DESERIALIZER, "boundary_scanner");
        op.add(Builder::boundaryScannerLocale, JsonpDeserializer.stringDeserializer(), "boundary_scanner_locale");
        op.add(Builder::encoder, HighlighterEncoder._DESERIALIZER, "encoder");
        op.add(Builder::fragmenter, HighlighterFragmenter._DESERIALIZER, "fragmenter");
        op.add(Builder::fragmentOffset, JsonpDeserializer.integerDeserializer(), "fragment_offset");
        op.add(Builder::fragmentSize, JsonpDeserializer.integerDeserializer(), "fragment_size");
        op.add(Builder::maxFragmentLength, JsonpDeserializer.integerDeserializer(), "max_fragment_length");
        op.add(Builder::noMatchSize, JsonpDeserializer.integerDeserializer(), "no_match_size");
        op.add(Builder::numberOfFragments, JsonpDeserializer.integerDeserializer(), "number_of_fragments");
        op.add(Builder::order, HighlighterOrder._DESERIALIZER, "order");
        op.add(Builder::postTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "post_tags");
        op.add(Builder::preTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pre_tags");
        op.add(Builder::requireFieldMatch, JsonpDeserializer.booleanDeserializer(), "require_field_match");
        op.add(Builder::tagsSchema, HighlighterTagsSchema._DESERIALIZER, "tags_schema");
        op.add(Builder::highlightQuery, Query._DESERIALIZER, "highlight_query");
        op.add(Builder::maxAnalyzedOffset, JsonpDeserializer.stringDeserializer(), "max_analyzed_offset");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Highlight> {
        private Map<String, HighlightField> fields;
        @Nullable
        private String type;
        @Nullable
        private String boundaryChars;
        @Nullable
        private Integer boundaryMaxScan;
        @Nullable
        private BoundaryScanner boundaryScanner;
        @Nullable
        private String boundaryScannerLocale;
        @Nullable
        private HighlighterEncoder encoder;
        @Nullable
        private HighlighterFragmenter fragmenter;
        @Nullable
        private Integer fragmentOffset;
        @Nullable
        private Integer fragmentSize;
        @Nullable
        private Integer maxFragmentLength;
        @Nullable
        private Integer noMatchSize;
        @Nullable
        private Integer numberOfFragments;
        @Nullable
        private HighlighterOrder order;
        @Nullable
        private List<String> postTags;
        @Nullable
        private List<String> preTags;
        @Nullable
        private Boolean requireFieldMatch;
        @Nullable
        private HighlighterTagsSchema tagsSchema;
        @Nullable
        private Query highlightQuery;
        @Nullable
        private String maxAnalyzedOffset;

        public final Builder fields(Map<String, HighlightField> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, HighlightField value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<HighlightField.Builder, ObjectBuilder<HighlightField>> fn) {
            return this.fields(key, fn.apply(new HighlightField.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder type(@Nullable HighlighterType value) {
            this.type = value == null ? null : value.jsonValue();
            return this;
        }

        public final Builder boundaryChars(@Nullable String value) {
            this.boundaryChars = value;
            return this;
        }

        public final Builder boundaryMaxScan(@Nullable Integer value) {
            this.boundaryMaxScan = value;
            return this;
        }

        public final Builder boundaryScanner(@Nullable BoundaryScanner value) {
            this.boundaryScanner = value;
            return this;
        }

        public final Builder boundaryScannerLocale(@Nullable String value) {
            this.boundaryScannerLocale = value;
            return this;
        }

        public final Builder encoder(@Nullable HighlighterEncoder value) {
            this.encoder = value;
            return this;
        }

        public final Builder fragmenter(@Nullable HighlighterFragmenter value) {
            this.fragmenter = value;
            return this;
        }

        public final Builder fragmentOffset(@Nullable Integer value) {
            this.fragmentOffset = value;
            return this;
        }

        public final Builder fragmentSize(@Nullable Integer value) {
            this.fragmentSize = value;
            return this;
        }

        public final Builder maxFragmentLength(@Nullable Integer value) {
            this.maxFragmentLength = value;
            return this;
        }

        public final Builder noMatchSize(@Nullable Integer value) {
            this.noMatchSize = value;
            return this;
        }

        public final Builder numberOfFragments(@Nullable Integer value) {
            this.numberOfFragments = value;
            return this;
        }

        public final Builder order(@Nullable HighlighterOrder value) {
            this.order = value;
            return this;
        }

        public final Builder postTags(List<String> list) {
            this.postTags = Builder._listAddAll(this.postTags, list);
            return this;
        }

        public final Builder postTags(String value, String ... values) {
            this.postTags = Builder._listAdd(this.postTags, value, values);
            return this;
        }

        public final Builder preTags(List<String> list) {
            this.preTags = Builder._listAddAll(this.preTags, list);
            return this;
        }

        public final Builder preTags(String value, String ... values) {
            this.preTags = Builder._listAdd(this.preTags, value, values);
            return this;
        }

        public final Builder requireFieldMatch(@Nullable Boolean value) {
            this.requireFieldMatch = value;
            return this;
        }

        public final Builder tagsSchema(@Nullable HighlighterTagsSchema value) {
            this.tagsSchema = value;
            return this;
        }

        public final Builder highlightQuery(@Nullable Query value) {
            this.highlightQuery = value;
            return this;
        }

        public final Builder highlightQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.highlightQuery(fn.apply(new Query.Builder()).build());
        }

        public final Builder maxAnalyzedOffset(@Nullable String value) {
            this.maxAnalyzedOffset = value;
            return this;
        }

        @Override
        public Highlight build() {
            this._checkSingleUse();
            return new Highlight(this);
        }
    }
}

