/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.FieldTypes;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class CharFilterTypes
implements JsonpSerializable {
    private final List<FieldTypes> charFilterTypes;
    private final List<FieldTypes> tokenizerTypes;
    private final List<FieldTypes> filterTypes;
    private final List<FieldTypes> analyzerTypes;
    private final List<FieldTypes> builtInCharFilters;
    private final List<FieldTypes> builtInTokenizers;
    private final List<FieldTypes> builtInFilters;
    private final List<FieldTypes> builtInAnalyzers;
    public static final JsonpDeserializer<CharFilterTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterTypes::setupCharFilterTypesDeserializer);

    private CharFilterTypes(Builder builder) {
        this.charFilterTypes = ApiTypeHelper.unmodifiableRequired(builder.charFilterTypes, (Object)this, "charFilterTypes");
        this.tokenizerTypes = ApiTypeHelper.unmodifiableRequired(builder.tokenizerTypes, (Object)this, "tokenizerTypes");
        this.filterTypes = ApiTypeHelper.unmodifiableRequired(builder.filterTypes, (Object)this, "filterTypes");
        this.analyzerTypes = ApiTypeHelper.unmodifiableRequired(builder.analyzerTypes, (Object)this, "analyzerTypes");
        this.builtInCharFilters = ApiTypeHelper.unmodifiableRequired(builder.builtInCharFilters, (Object)this, "builtInCharFilters");
        this.builtInTokenizers = ApiTypeHelper.unmodifiableRequired(builder.builtInTokenizers, (Object)this, "builtInTokenizers");
        this.builtInFilters = ApiTypeHelper.unmodifiableRequired(builder.builtInFilters, (Object)this, "builtInFilters");
        this.builtInAnalyzers = ApiTypeHelper.unmodifiableRequired(builder.builtInAnalyzers, (Object)this, "builtInAnalyzers");
    }

    public static CharFilterTypes of(Function<Builder, ObjectBuilder<CharFilterTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldTypes> charFilterTypes() {
        return this.charFilterTypes;
    }

    public final List<FieldTypes> tokenizerTypes() {
        return this.tokenizerTypes;
    }

    public final List<FieldTypes> filterTypes() {
        return this.filterTypes;
    }

    public final List<FieldTypes> analyzerTypes() {
        return this.analyzerTypes;
    }

    public final List<FieldTypes> builtInCharFilters() {
        return this.builtInCharFilters;
    }

    public final List<FieldTypes> builtInTokenizers() {
        return this.builtInTokenizers;
    }

    public final List<FieldTypes> builtInFilters() {
        return this.builtInFilters;
    }

    public final List<FieldTypes> builtInAnalyzers() {
        return this.builtInAnalyzers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.charFilterTypes)) {
            generator.writeKey("char_filter_types");
            generator.writeStartArray();
            for (FieldTypes item0 : this.charFilterTypes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tokenizerTypes)) {
            generator.writeKey("tokenizer_types");
            generator.writeStartArray();
            for (FieldTypes item0 : this.tokenizerTypes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filterTypes)) {
            generator.writeKey("filter_types");
            generator.writeStartArray();
            for (FieldTypes item0 : this.filterTypes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.analyzerTypes)) {
            generator.writeKey("analyzer_types");
            generator.writeStartArray();
            for (FieldTypes item0 : this.analyzerTypes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.builtInCharFilters)) {
            generator.writeKey("built_in_char_filters");
            generator.writeStartArray();
            for (FieldTypes item0 : this.builtInCharFilters) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.builtInTokenizers)) {
            generator.writeKey("built_in_tokenizers");
            generator.writeStartArray();
            for (FieldTypes item0 : this.builtInTokenizers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.builtInFilters)) {
            generator.writeKey("built_in_filters");
            generator.writeStartArray();
            for (FieldTypes item0 : this.builtInFilters) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.builtInAnalyzers)) {
            generator.writeKey("built_in_analyzers");
            generator.writeStartArray();
            for (FieldTypes item0 : this.builtInAnalyzers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCharFilterTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "char_filter_types");
        op.add(Builder::tokenizerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "tokenizer_types");
        op.add(Builder::filterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "filter_types");
        op.add(Builder::analyzerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "analyzer_types");
        op.add(Builder::builtInCharFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_char_filters");
        op.add(Builder::builtInTokenizers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_tokenizers");
        op.add(Builder::builtInFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_filters");
        op.add(Builder::builtInAnalyzers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_analyzers");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CharFilterTypes> {
        private List<FieldTypes> charFilterTypes;
        private List<FieldTypes> tokenizerTypes;
        private List<FieldTypes> filterTypes;
        private List<FieldTypes> analyzerTypes;
        private List<FieldTypes> builtInCharFilters;
        private List<FieldTypes> builtInTokenizers;
        private List<FieldTypes> builtInFilters;
        private List<FieldTypes> builtInAnalyzers;

        public final Builder charFilterTypes(List<FieldTypes> list) {
            this.charFilterTypes = Builder._listAddAll(this.charFilterTypes, list);
            return this;
        }

        public final Builder charFilterTypes(FieldTypes value, FieldTypes ... values) {
            this.charFilterTypes = Builder._listAdd(this.charFilterTypes, value, values);
            return this;
        }

        public final Builder charFilterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.charFilterTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder tokenizerTypes(List<FieldTypes> list) {
            this.tokenizerTypes = Builder._listAddAll(this.tokenizerTypes, list);
            return this;
        }

        public final Builder tokenizerTypes(FieldTypes value, FieldTypes ... values) {
            this.tokenizerTypes = Builder._listAdd(this.tokenizerTypes, value, values);
            return this;
        }

        public final Builder tokenizerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.tokenizerTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder filterTypes(List<FieldTypes> list) {
            this.filterTypes = Builder._listAddAll(this.filterTypes, list);
            return this;
        }

        public final Builder filterTypes(FieldTypes value, FieldTypes ... values) {
            this.filterTypes = Builder._listAdd(this.filterTypes, value, values);
            return this;
        }

        public final Builder filterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.filterTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder analyzerTypes(List<FieldTypes> list) {
            this.analyzerTypes = Builder._listAddAll(this.analyzerTypes, list);
            return this;
        }

        public final Builder analyzerTypes(FieldTypes value, FieldTypes ... values) {
            this.analyzerTypes = Builder._listAdd(this.analyzerTypes, value, values);
            return this;
        }

        public final Builder analyzerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.analyzerTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder builtInCharFilters(List<FieldTypes> list) {
            this.builtInCharFilters = Builder._listAddAll(this.builtInCharFilters, list);
            return this;
        }

        public final Builder builtInCharFilters(FieldTypes value, FieldTypes ... values) {
            this.builtInCharFilters = Builder._listAdd(this.builtInCharFilters, value, values);
            return this;
        }

        public final Builder builtInCharFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInCharFilters(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder builtInTokenizers(List<FieldTypes> list) {
            this.builtInTokenizers = Builder._listAddAll(this.builtInTokenizers, list);
            return this;
        }

        public final Builder builtInTokenizers(FieldTypes value, FieldTypes ... values) {
            this.builtInTokenizers = Builder._listAdd(this.builtInTokenizers, value, values);
            return this;
        }

        public final Builder builtInTokenizers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInTokenizers(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder builtInFilters(List<FieldTypes> list) {
            this.builtInFilters = Builder._listAddAll(this.builtInFilters, list);
            return this;
        }

        public final Builder builtInFilters(FieldTypes value, FieldTypes ... values) {
            this.builtInFilters = Builder._listAdd(this.builtInFilters, value, values);
            return this;
        }

        public final Builder builtInFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInFilters(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder builtInAnalyzers(List<FieldTypes> list) {
            this.builtInAnalyzers = Builder._listAddAll(this.builtInAnalyzers, list);
            return this;
        }

        public final Builder builtInAnalyzers(FieldTypes value, FieldTypes ... values) {
            this.builtInAnalyzers = Builder._listAdd(this.builtInAnalyzers, value, values);
            return this;
        }

        public final Builder builtInAnalyzers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInAnalyzers(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Override
        public CharFilterTypes build() {
            this._checkSingleUse();
            return new CharFilterTypes(this);
        }
    }
}

