/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.health.IndexHealthStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HealthResponse
implements JsonpSerializable {
    private final int activePrimaryShards;
    private final int activeShards;
    private final String activeShardsPercentAsNumber;
    private final String clusterName;
    private final int delayedUnassignedShards;
    private final Map<String, IndexHealthStats> indices;
    private final int initializingShards;
    private final int numberOfDataNodes;
    private final int numberOfInFlightFetch;
    private final int numberOfNodes;
    private final int numberOfPendingTasks;
    private final int relocatingShards;
    private final HealthStatus status;
    private final DateTime taskMaxWaitingInQueueMillis;
    private final boolean timedOut;
    private final int unassignedShards;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthResponse::setupHealthResponseDeserializer);

    private HealthResponse(Builder builder) {
        this.activePrimaryShards = ApiTypeHelper.requireNonNull(builder.activePrimaryShards, this, "activePrimaryShards");
        this.activeShards = ApiTypeHelper.requireNonNull(builder.activeShards, this, "activeShards");
        this.activeShardsPercentAsNumber = ApiTypeHelper.requireNonNull(builder.activeShardsPercentAsNumber, this, "activeShardsPercentAsNumber");
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.delayedUnassignedShards = ApiTypeHelper.requireNonNull(builder.delayedUnassignedShards, this, "delayedUnassignedShards");
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.initializingShards = ApiTypeHelper.requireNonNull(builder.initializingShards, this, "initializingShards");
        this.numberOfDataNodes = ApiTypeHelper.requireNonNull(builder.numberOfDataNodes, this, "numberOfDataNodes");
        this.numberOfInFlightFetch = ApiTypeHelper.requireNonNull(builder.numberOfInFlightFetch, this, "numberOfInFlightFetch");
        this.numberOfNodes = ApiTypeHelper.requireNonNull(builder.numberOfNodes, this, "numberOfNodes");
        this.numberOfPendingTasks = ApiTypeHelper.requireNonNull(builder.numberOfPendingTasks, this, "numberOfPendingTasks");
        this.relocatingShards = ApiTypeHelper.requireNonNull(builder.relocatingShards, this, "relocatingShards");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.taskMaxWaitingInQueueMillis = ApiTypeHelper.requireNonNull(builder.taskMaxWaitingInQueueMillis, this, "taskMaxWaitingInQueueMillis");
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, this, "timedOut");
        this.unassignedShards = ApiTypeHelper.requireNonNull(builder.unassignedShards, this, "unassignedShards");
    }

    public static HealthResponse of(Function<Builder, ObjectBuilder<HealthResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public final int activeShards() {
        return this.activeShards;
    }

    public final String activeShardsPercentAsNumber() {
        return this.activeShardsPercentAsNumber;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final int delayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public final Map<String, IndexHealthStats> indices() {
        return this.indices;
    }

    public final int initializingShards() {
        return this.initializingShards;
    }

    public final int numberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public final int numberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public final int numberOfNodes() {
        return this.numberOfNodes;
    }

    public final int numberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public final int relocatingShards() {
        return this.relocatingShards;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final DateTime taskMaxWaitingInQueueMillis() {
        return this.taskMaxWaitingInQueueMillis;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("active_shards_percent_as_number");
        generator.write(this.activeShardsPercentAsNumber);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("delayed_unassigned_shards");
        generator.write(this.delayedUnassignedShards);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndexHealthStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_data_nodes");
        generator.write(this.numberOfDataNodes);
        generator.writeKey("number_of_in_flight_fetch");
        generator.write(this.numberOfInFlightFetch);
        generator.writeKey("number_of_nodes");
        generator.write(this.numberOfNodes);
        generator.writeKey("number_of_pending_tasks");
        generator.write(this.numberOfPendingTasks);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("task_max_waiting_in_queue_millis");
        this.taskMaxWaitingInQueueMillis.serialize(generator, mapper);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupHealthResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards");
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(Builder::activeShardsPercentAsNumber, JsonpDeserializer.stringDeserializer(), "active_shards_percent_as_number");
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::delayedUnassignedShards, JsonpDeserializer.integerDeserializer(), "delayed_unassigned_shards");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexHealthStats._DESERIALIZER), "indices");
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(Builder::numberOfDataNodes, JsonpDeserializer.integerDeserializer(), "number_of_data_nodes");
        op.add(Builder::numberOfInFlightFetch, JsonpDeserializer.integerDeserializer(), "number_of_in_flight_fetch");
        op.add(Builder::numberOfNodes, JsonpDeserializer.integerDeserializer(), "number_of_nodes");
        op.add(Builder::numberOfPendingTasks, JsonpDeserializer.integerDeserializer(), "number_of_pending_tasks");
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::taskMaxWaitingInQueueMillis, DateTime._DESERIALIZER, "task_max_waiting_in_queue_millis");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HealthResponse> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        private String activeShardsPercentAsNumber;
        private String clusterName;
        private Integer delayedUnassignedShards;
        @Nullable
        private Map<String, IndexHealthStats> indices;
        private Integer initializingShards;
        private Integer numberOfDataNodes;
        private Integer numberOfInFlightFetch;
        private Integer numberOfNodes;
        private Integer numberOfPendingTasks;
        private Integer relocatingShards;
        private HealthStatus status;
        private DateTime taskMaxWaitingInQueueMillis;
        private Boolean timedOut;
        private Integer unassignedShards;

        public final Builder activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return this;
        }

        public final Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public final Builder activeShardsPercentAsNumber(String value) {
            this.activeShardsPercentAsNumber = value;
            return this;
        }

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder delayedUnassignedShards(int value) {
            this.delayedUnassignedShards = value;
            return this;
        }

        public final Builder indices(Map<String, IndexHealthStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, IndexHealthStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<IndexHealthStats.Builder, ObjectBuilder<IndexHealthStats>> fn) {
            return this.indices(key, fn.apply(new IndexHealthStats.Builder()).build());
        }

        public final Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public final Builder numberOfDataNodes(int value) {
            this.numberOfDataNodes = value;
            return this;
        }

        public final Builder numberOfInFlightFetch(int value) {
            this.numberOfInFlightFetch = value;
            return this;
        }

        public final Builder numberOfNodes(int value) {
            this.numberOfNodes = value;
            return this;
        }

        public final Builder numberOfPendingTasks(int value) {
            this.numberOfPendingTasks = value;
            return this;
        }

        public final Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder taskMaxWaitingInQueueMillis(DateTime value) {
            this.taskMaxWaitingInQueueMillis = value;
            return this;
        }

        public final Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public HealthResponse build() {
            this._checkSingleUse();
            return new HealthResponse(this);
        }
    }
}

