/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ActivationState
implements JsonpSerializable {
    private final boolean active;
    private final DateTime timestamp;
    public static final JsonpDeserializer<ActivationState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActivationState::setupActivationStateDeserializer);

    private ActivationState(Builder builder) {
        this.active = ApiTypeHelper.requireNonNull(builder.active, this, "active");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ActivationState of(Function<Builder, ObjectBuilder<ActivationState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean active() {
        return this.active;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    protected static void setupActivationStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.booleanDeserializer(), "active");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ActivationState> {
        private Boolean active;
        private DateTime timestamp;

        public final Builder active(boolean value) {
            this.active = value;
            return this;
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public ActivationState build() {
            this._checkSingleUse();
            return new ActivationState(this);
        }
    }
}

