/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApiKey;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryApiKeysResponse
implements JsonpSerializable {
    private final int total;
    private final int count;
    private final List<ApiKey> apiKeys;
    public static final JsonpDeserializer<QueryApiKeysResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryApiKeysResponse::setupQueryApiKeysResponseDeserializer);

    private QueryApiKeysResponse(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.apiKeys = ApiTypeHelper.unmodifiableRequired(builder.apiKeys, (Object)this, "apiKeys");
    }

    public static QueryApiKeysResponse of(Function<Builder, ObjectBuilder<QueryApiKeysResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int count() {
        return this.count;
    }

    public final List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.apiKeys)) {
            generator.writeKey("api_keys");
            generator.writeStartArray();
            for (ApiKey item0 : this.apiKeys) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryApiKeysResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::apiKeys, JsonpDeserializer.arrayDeserializer(ApiKey._DESERIALIZER), "api_keys");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<QueryApiKeysResponse> {
        private Integer total;
        private Integer count;
        private List<ApiKey> apiKeys;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder apiKeys(List<ApiKey> list) {
            this.apiKeys = Builder._listAddAll(this.apiKeys, list);
            return this;
        }

        public final Builder apiKeys(ApiKey value, ApiKey ... values) {
            this.apiKeys = Builder._listAdd(this.apiKeys, value, values);
            return this;
        }

        public final Builder apiKeys(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.apiKeys(fn.apply(new ApiKey.Builder()).build(), new ApiKey[0]);
        }

        @Override
        public QueryApiKeysResponse build() {
            this._checkSingleUse();
            return new QueryApiKeysResponse(this);
        }
    }
}

