/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TopClassEntry;
import co.elastic.clients.elasticsearch.ml.TrainedModelEntities;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferTrainedModelDeploymentResponse
implements JsonpSerializable {
    private final List<TrainedModelEntities> entities;
    @Nullable
    private final Boolean isTruncated;
    private final List<String> predictedValue;
    @Nullable
    private final String predictedValueSequence;
    @Nullable
    private final Double predictionProbability;
    private final List<TopClassEntry> topClasses;
    @Nullable
    private final String warning;
    public static final JsonpDeserializer<InferTrainedModelDeploymentResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferTrainedModelDeploymentResponse::setupInferTrainedModelDeploymentResponseDeserializer);

    private InferTrainedModelDeploymentResponse(Builder builder) {
        this.entities = ApiTypeHelper.unmodifiable(builder.entities);
        this.isTruncated = builder.isTruncated;
        this.predictedValue = ApiTypeHelper.unmodifiable(builder.predictedValue);
        this.predictedValueSequence = builder.predictedValueSequence;
        this.predictionProbability = builder.predictionProbability;
        this.topClasses = ApiTypeHelper.unmodifiableRequired(builder.topClasses, (Object)this, "topClasses");
        this.warning = builder.warning;
    }

    public static InferTrainedModelDeploymentResponse of(Function<Builder, ObjectBuilder<InferTrainedModelDeploymentResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TrainedModelEntities> entities() {
        return this.entities;
    }

    @Nullable
    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final List<String> predictedValue() {
        return this.predictedValue;
    }

    @Nullable
    public final String predictedValueSequence() {
        return this.predictedValueSequence;
    }

    @Nullable
    public final Double predictionProbability() {
        return this.predictionProbability;
    }

    public final List<TopClassEntry> topClasses() {
        return this.topClasses;
    }

    @Nullable
    public final String warning() {
        return this.warning;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.entities)) {
            generator.writeKey("entities");
            generator.writeStartArray();
            for (TrainedModelEntities trainedModelEntities : this.entities) {
                trainedModelEntities.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.isTruncated != null) {
            generator.writeKey("is_truncated");
            generator.write(this.isTruncated.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.predictedValue)) {
            generator.writeKey("predicted_value");
            generator.writeStartArray();
            for (String string : this.predictedValue) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.predictedValueSequence != null) {
            generator.writeKey("predicted_value_sequence");
            generator.write(this.predictedValueSequence);
        }
        if (this.predictionProbability != null) {
            generator.writeKey("prediction_probability");
            generator.write(this.predictionProbability.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.topClasses)) {
            generator.writeKey("top_classes");
            generator.writeStartArray();
            for (TopClassEntry topClassEntry : this.topClasses) {
                topClassEntry.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.warning != null) {
            generator.writeKey("warning");
            generator.write(this.warning);
        }
    }

    protected static void setupInferTrainedModelDeploymentResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::entities, JsonpDeserializer.arrayDeserializer(TrainedModelEntities._DESERIALIZER), "entities");
        op.add(Builder::isTruncated, JsonpDeserializer.booleanDeserializer(), "is_truncated");
        op.add(Builder::predictedValue, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "predicted_value");
        op.add(Builder::predictedValueSequence, JsonpDeserializer.stringDeserializer(), "predicted_value_sequence");
        op.add(Builder::predictionProbability, JsonpDeserializer.doubleDeserializer(), "prediction_probability");
        op.add(Builder::topClasses, JsonpDeserializer.arrayDeserializer(TopClassEntry._DESERIALIZER), "top_classes");
        op.add(Builder::warning, JsonpDeserializer.stringDeserializer(), "warning");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InferTrainedModelDeploymentResponse> {
        @Nullable
        private List<TrainedModelEntities> entities;
        @Nullable
        private Boolean isTruncated;
        @Nullable
        private List<String> predictedValue;
        @Nullable
        private String predictedValueSequence;
        @Nullable
        private Double predictionProbability;
        private List<TopClassEntry> topClasses;
        @Nullable
        private String warning;

        public final Builder entities(List<TrainedModelEntities> list) {
            this.entities = Builder._listAddAll(this.entities, list);
            return this;
        }

        public final Builder entities(TrainedModelEntities value, TrainedModelEntities ... values) {
            this.entities = Builder._listAdd(this.entities, value, values);
            return this;
        }

        public final Builder entities(Function<TrainedModelEntities.Builder, ObjectBuilder<TrainedModelEntities>> fn) {
            return this.entities(fn.apply(new TrainedModelEntities.Builder()).build(), new TrainedModelEntities[0]);
        }

        public final Builder isTruncated(@Nullable Boolean value) {
            this.isTruncated = value;
            return this;
        }

        public final Builder predictedValue(List<String> list) {
            this.predictedValue = Builder._listAddAll(this.predictedValue, list);
            return this;
        }

        public final Builder predictedValue(String value, String ... values) {
            this.predictedValue = Builder._listAdd(this.predictedValue, value, values);
            return this;
        }

        public final Builder predictedValueSequence(@Nullable String value) {
            this.predictedValueSequence = value;
            return this;
        }

        public final Builder predictionProbability(@Nullable Double value) {
            this.predictionProbability = value;
            return this;
        }

        public final Builder topClasses(List<TopClassEntry> list) {
            this.topClasses = Builder._listAddAll(this.topClasses, list);
            return this;
        }

        public final Builder topClasses(TopClassEntry value, TopClassEntry ... values) {
            this.topClasses = Builder._listAdd(this.topClasses, value, values);
            return this;
        }

        public final Builder topClasses(Function<TopClassEntry.Builder, ObjectBuilder<TopClassEntry>> fn) {
            return this.topClasses(fn.apply(new TopClassEntry.Builder()).build(), new TopClassEntry[0]);
        }

        public final Builder warning(@Nullable String value) {
            this.warning = value;
            return this;
        }

        @Override
        public InferTrainedModelDeploymentResponse build() {
            this._checkSingleUse();
            return new InferTrainedModelDeploymentResponse(this);
        }
    }
}

